# CVE-2024-34470 PoC and Bulk Scanner

## Overview

This is a proof-of-concept (PoC) and bulk scanner for CVE-2024-34470: Path Traversal vulnerability HSC Mailinspector affects all versions up to 5.2.18.

![Banner](screens/screen.jpg)


## How to Use

### POC in Action:

[![IMAGE POC IN ACTION](https://img.youtube.com/vi/tTkHxQZ2zF4/0.jpg)](https://www.youtube.com/watch?v=tTkHxQZ2zF4)

### Single Target Scan

To scan a single target IP:
```sh
python cve-2024-34470.py -u target
```

### Bulk Target Scan
To mass scan bulk targets:
```sh
python cve-2024-34470.py -f targets.txt
```

## Installation

### Minimum Requirements

- Python 3.6 or higher
- `requests` library

### Installing The Script

```sh
git clone https://github.com/bigb0x/CVE-2024-34470.git; cd CVE-2024-34470
```

### Installing Required Packages

Install the required packages using pip:

```sh
pip install requests
```

## Author

POC was created by [M Ali](https://x.com/MohamedNab1l).

## License

This project is licensed under the MIT License.

## Disclaimer

This provided tool is for educational purposes only. I do not encourage, condone, or support unauthorized access to any system or network. Use this tool responsibly and only on systems you have explicit permission to test. Any actions and consequences resulting from misuse of this tool are your own responsibility.

## References
- https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2024-34470
- https://github.com/osvaldotenorio/CVE-2024-34470
