import subprocess

def getData(index1, index2, byteArray):
    mask = 0xFF
    d = ((byteArray[index1] & mask) << 8) + (byteArray[index2] & mask)
    return d / 10.0

def getWeight(byteArray):
    return getData(4, 5, byteArray)

def getTemp(byteArray):
    return getData(2, 3, byteArray)

def parse_line(line):
    parts = line.split(' ')
    hex_data = ''.join(parts[2:])
    if len(hex_data)==34 and hex_data.startswith('10FF'):
        byte_array = bytes.fromhex(hex_data)
        weight = getWeight(byte_array) 
        print(f"Weight: {weight}")
def run_c_executable(path_to_executable):
    process = subprocess.Popen([path_to_executable], stdout=subprocess.PIPE, stderr=subprocess.PIPE, text=True)
    while True:
        output = process.stdout.readline()
        if output == '' and process.poll() is not None:
            print("Keeping scan open")
            run_c_executable(path_to_executable)
        if output:
            parse_line(output.strip())

if __name__ == "__main__":
    path_to_executable = "./scanner"  # Update this to your executable's path
    run_c_executable(path_to_executable)

