# CVE-2024-34444 - Slider Revolution Missing Authorization Scanner

[![Python](https://img.shields.io/badge/Python-3.8+-blue.svg)](https://www.python.org/downloads/)
[![License](https://img.shields.io/badge/License-MIT-green.svg)](LICENSE)
[![CVE](https://img.shields.io/badge/CVE-2024--34444-red.svg)](https://nvd.nist.gov/vuln/detail/CVE-2024-34444)
[![Stars](https://img.shields.io/github/stars/dzmind2312/CVE-2024-34444?style=social)](https://github.com/dzmind2312/CVE-2024-34444)

**Professional mass scanner for CVE-2024-34444 affecting Slider Revolution WordPress plugin < 6.7.0**

![Banner](screenshots/banner.png)

## 🎯 Description

CVE-2024-34444 is a **Missing Authorization** vulnerability in the Slider Revolution WordPress plugin (versions < 6.7.0). This scanner automates the detection and exploitation of vulnerable installations through the REST API endpoint `/wp-json/revslider/v1/slider/save`.

### Technical Details

- **CVE ID**: CVE-2024-34444
- **CVSS Score**: 7.5 (High)
- **Plugin**: Slider Revolution (Premium WordPress plugin)
- **Affected Versions**: < 6.7.0
- **Attack Vector**: Network (Unauthenticated)
- **CWE**: CWE-862 (Missing Authorization)

**Vulnerability Chain:**
1. Extract `revslider_actions` nonce from frontend (publicly accessible)
2. Use nonce to bypass `check_nonce()` in REST API
3. Modify slider data without authentication
4. Chain with XSS (CVE-2024-34443) for full RCE

---

## 🚀 Features

- ✅ **Multi-threaded scanning** (1-100 threads)
- ✅ **Professional UI** with Rich console (colors, progress bar, tables)
- ✅ **DZ Mind Injector banner** (ASCII art)
- ✅ **Automatic version detection** via `readme.txt`
- ✅ **Nonce extraction** from multiple JS patterns
- ✅ **Real-time notifications** of vulnerable targets
- ✅ **Verbose mode** (`-v`) for detailed logging
- ✅ **Output file** (`-o`) to save results
- ✅ **Statistics table** with percentages
- ✅ **Single target** or **mass scanning** support

---

## 📦 Installation

### Requirements
- Python 3.8+
- pip3

### Clone & Install

```bash
git clone https://github.com/dzmind2312/CVE-2024-34444.git
cd CVE-2024-34444
pip3 install -r requirements.txt
# Single target
python3 exploit.py -u https://target.com

# Single target with verbose
python3 exploit.py -u https://target.com -v

# Mass scan from list
python3 exploit.py -l targets.txt -t 20

# Mass scan with output file
python3 exploit.py -l sites.txt -t 50 -o vulnerable.txt

# Full example with all options
python3 exploit.py -l targets.txt -t 100 -o results.txt -v
