
# CVE-2024-34327 SQL Injection Vulnerability Checker

This script (`V-24-02-001_SQLi_Check.py`) is a **proof-of-concept (PoC)** tool to verify the presence of a **time-based blind SQL injection vulnerability** affecting the `password-reset-token.php` endpoint, identified as **CVE-2024-34327**.

## ⚠️ Disclaimer

This tool is intended **for educational and authorized testing purposes only**. Unauthorized scanning or exploitation of systems without consent is illegal and unethical.

---

## 🔍 Vulnerability Details

- **CVE ID**: CVE-2024-34327  
- **Vulnerability Title**: Time-Based Blind SQL Injection
- **Product**: Sielox AnyWare
- **Version Affected**: 2.1.2
- **Vulnerable Endpoint**: `/auth/password-reset-token.php`  
- **Injection Vector**: `email` parameter in POST data  
- **Exploitation Method**: SQL `SLEEP()` function to measure delay in server response

---

## 🧪 Features

- Automatically sends a crafted POST request with a 10-second SQL delay
- Measures server response time to infer vulnerability
- Randomly generates a `PHPSESSID` cookie value for each run

---

## 🛠 Usage

### Prerequisites

- Python 3.x
- `requests` library (`pip install requests`)

### Command

```bash
python3 V-24-02-001_SQLi_Check.py --url https://target-domain.com
```

### Example

```bash
python3 V-24-02-001_SQLi_Check.py --url https://vulnerable-site.com
```

### Output

- `[+] VULNERABLE` if the server response delay exceeds 9 seconds
- `[-] NOT VULNERABLE` otherwise

---

## 🧾 How It Works

1. Sends a POST request with the payload:
   ```
   data[email]=test@doesnotexist.com'+AND+(SELECT+8161+FROM+(SELECT(SLEEP(10)))uvHC)+AND+'abcd'='abcd
   ```
2. If the response takes **>9 seconds**, the tool reports the server as **VULNERABLE**.
3. All TLS verification warnings are suppressed for testing convenience.

---

## 🧰 Script Internals

- Uses Python’s `requests` library
- Sets common HTTP headers including a realistic `User-Agent` and `Referer`
- Generates a random PHP session ID per request

---

## 🔒 Legal Note

You are responsible for using this tool ethically. The author assumes **no liability** for any misuse.

---

## 👨‍💻 Author

Security Researcher – [Your Name or Alias]  
Feel free to contribute or report issues.
