#!/usr/bin/env python3
"""
Start D-Tale with sample data for CVE-2024-3408 testing.
The vulnerability exists in dtale <= 3.10.0 due to:
1. Hardcoded SECRET_KEY allowing session cookie forgery
2. Unsafe eval/exec in various endpoints (custom filters, build column, etc.)
"""
import pandas as pd
import dtale

# Create sample DataFrame
df = pd.DataFrame({
    'id': [1, 2, 3, 4, 5],
    'name': ['Alice', 'Bob', 'Charlie', 'David', 'Eve'],
    'value': [100, 200, 150, 300, 250]
})

# Start D-Tale server
# host='0.0.0.0' allows external connections
# open_browser=False for headless/container mode
d = dtale.show(df, host='0.0.0.0', port=40000, open_browser=False)

print(f"D-Tale started at: {d._url}")
print("Press Ctrl+C to stop...")

# Keep the process running
import time
while True:
    time.sleep(1)

