# CVE-2024-33298
Stored Cross Site Scripting vulnerability in Microweber <= 2.0.9

## Summary :

A Stored Cross Site Scripting vulnerability in Microweber v.2.0.9 allows a remote attacker to execute arbitrary code via the create new backup function in the endpoint **/admin/module/view?type=admin__backup**

## Requirements :

- [Microweber](https://github.com/microweber/microweber) version <= 2.0.9
- Admin access

## Steps to reproduce :

1. Authenticate the application with administrative privileges
2. Go to the endpoint **/admin/module/view?type=admin__backup** and click on **"Create New Backup"**
3. Select any option between **"Content backup"**, **"Custom backup"** or **"Full backup"** as any of them can be used to trigger the JavaScript injection (if **"Custom backup"** is selected, make sure to check **"Include media files"** on the next page)
4. Start backup and download the newly generated .zip file
5. Open the zip file and insert a new file named `<img src=x onerror=alert(1)>.jpg` on **/media/default/**
6. Go back to the endpoint **/admin/module/view?type=admin__backup** and click on **"Upload file"**
7. Upload the modified zip file
8. After the upload, on the **"ACTIONS"** section of the newly uploaded file, click on **"Restore"**
9. Select any option between **"Delete all website content & restore"**, **"Overwrite the website content from backup"** or **"Try to overwrite content by Names & Titles"** as all fields can be used to trigger the JavaScript injection.
10. After the upload, go to the endpoint **/admin/module/view?type=files** or **/admin/settings?group=files** to trigger the JavaScript injection.

## Affected components :

- /admin/module/view?type=files
- /admin/settings?group=files

## Impact :

An attacker could execute JavaScript code in the victim's browser, obtaining information or forcing the user to access malicious websites, for example.

## Relevant References

https://www.cve.org/CVERecord?id=CVE-2024-33298
