from crypto import _AES256CTS, Key, _enctype_table, Enctype


TGS = bytes.fromhex('4283dec4b219b486788d2707129abf8ff09f7998b33a78bbc580da9138bc4e872cae2d3d888309e861e167019360faf9b8cb0c2534ffbd2f533ff4214c2b524987bb934893312d56083e9cb0c38b51b856d825f607a4207'
                        'cc00954abdcaae1f50071b3b26ba9b03155b075f304c338d931cdc3322b0443d88236c5aa1b3df44a793e2287cefaf78b0fb2b5008420e382347f45ac80f4504fca5a209ba5a449050accfa631672aa3be8a2e40b843d14'
                        '6653d5809ab768565f3591d84f1b678bc8ebed99e7ec32bd8dc3aa80fd592226d69cc8281f7575d4add96611bdce18481223b8ccc112d3979457dea33c0043ebd6def995d9a59e3fdfdc0f4fdb8cfaf6dfc37e1027a9199'
                        '25daa0d1e4b2ad2cdbd690022c728aa151d12a0732b591a4ab4eda3d6c405f77967b5f03ed6e49d6ece3fd401a65d4e88333cca70adff7c45d7e010414db4ea1f5c3a54328463cbf201b9021eeed604a62a49c35063a09ca'
                        '92eb436e281d30d0a7179ef21842a25d03ca512c624584f1232629bb53f9c5f424554a408dd3df1647641b25ecebe09b6f859f516222e7642583aec4463ec099b04b208f723ddcd433db6870afe063064de3030f8486c14d'
                        '0869c264d057e0235763c3ce65627308158f778f0c0e8410c300f24c08ba6fc085ba4f8ad87da646e20b5f712aef8e41b78efd86b8933df9972aedf8105eeb47f9bd9a0cc7838ec6acdd6ef8e143d234bbcb7cfea48bcf12'
                        'cc3ef72a336e1b4eff370ed0e50e3aba0e17ab177c7ec14e4597991de87798ee185b9f606a6565a973083c39a41ad44cb77456f91dfd4ccef21139e0e573345fffcde744ae4a624ad518d3713b17fd0dd8bdd74d079cc0f6'
                        '5f2cb7b378b2165b89b696cb2172caa0ef45a7e05844923936de79ac21ef6d756e8157e6ad110dac78f037368bea9e11e687bbcc30179b172b41be4385f8294fd83182d81a29e696707aec8f1eb90457bc31b8e01abbd6cd'
                        '3bdaac6715b22d261a1da06513705354bc704d55aa42f33a79cc28fc8a7a4aef0b3263ba53e1810b279f39d05b99b4b79ecee58d221a3029f07ab1454fd932dca8999b940b884bf76f445279ebd54ad167209bfda05e9bd27'
                        '028048f46fd699af6f257929eb06c9bf81d95801ce9079128bf7b819ab9db728c8a2d78081a06aafedd0447584ed69b37897c2f0b7ffec024e1d2625e4626599b1889dc1a241b6b2b392bd6e501f7993c17a546dceca331015'
                        'cf42e32cc9d2320228cc62c983c3e3559df5ad4438fdc38e18d592afd733dec4b2e6d66f748d3e2fbe60c560b7eb7d018f16e2d4c2b5a71d20eec713d17b018deb0ac230a2e2668befb318c3ec412d5a1949aa91bc118a3669'
                        'dcb64a9357aa1aaecac7a6463870cfd4743c5b9484f911a33d7d94e9eb68103997f83d75ae6e5e102991de807f29de573da85b093ead0a993ab5b0d29b2038683947ed8d449cc643bac5febbd882ea557076486d0861cb4a0c3'
                        '86e871c84903a8a9490e95239fa1e971b6f4e10712aa2a38991d0adcd2c1124512f0400c139ec8857764bbbdd9b41384af28f6818f1f92f86de958a1f17463abd255214ce2d7d1da407197d95cd5fbea4df19ba79681d8eae094'
                        '04b5ca76bc4164f78c19f9e79b4b3b1621dde19cf25eb6a0476ef2bdb390d7720c9')

SALT = "`B,\\ CQb !MIm@4N"


newCipher = _enctype_table[Enctype.AES256]
test_password = ['abcd',
                 'P@ssword123',
                 'roottoor',
                 'Password']

for i in test_password:
    aesKey = _AES256CTS.string_to_key(i, SALT, params=None).contents
    try:
        PlainText = newCipher.decrypt(Key(newCipher.enctype, aesKey), 2, TGS)
        print('Password:', i)
    except Exception:
        print('Wrong password')
