# CVE-2024-3094-info

- CVE-2024-3094 PoC Exploration https://github.com/amlweems/xzbot
  
- https://github.com/lockness-Ko/xz-vulnerable-honeypot

- https://tukaani.org/xz-backdoor/ - Lasse Collin response
 
- https://gist.github.com/thesamesam/223949d5a074ebc3dce9ee78baad9e27

- https://www.thestack.technology/xz-utils-github-repository-disabled-as-linux-maintainers-assess-blast-radius-of-backdoor-earlier-commits/

- https://www.reddit.com/r/linux/comments/1brhlur/xz_utils_backdoor/

- https://gist.github.com/smx-smx/a6112d54777845d389bd7126d6e9f504

Information for CVE-2024-3094

Red Hat today issued an "urgent security alert" for Fedora 41 and Fedora Rawhide users over XZ. Yes, the XZ tools and libraries for this compression format. Some malicious code was added to XZ 5.6.0/5.6.1 that could allow unauthorized remote system access.

Red Hat cites CVE-2024-3094 for this XZ security vulnerability due to malicious code making it into the codebase. I haven't seen CVE-2024-3094 made public yet but the Red Hat security alert sums it up as:
"The malicious injection present in the xz versions 5.6.0 and 5.6.1 libraries is obfuscated and only included in full in the download package - the Git distribution lacks the M4 macro that triggers the build of the malicious code. The second-stage artifacts are present in the Git repository for the injection during the build time, in case the malicious M4 macro is present.

The resulting malicious build interferes with authentication in sshd via systemd. SSH is a commonly used protocol for connecting remotely to systems, and sshd is the service that allows access. Under the right circumstances this interference could potentially enable a malicious actor to break sshd authentication and gain unauthorized access to the entire system remotely."

- https://isc.sans.edu/podcastdetail/8918

Backdoor reverse analysis
- https://bsky.app/profile/did:plc:x2nsupeeo52oznrmplwapppl/post/3kowjkx2njy2b

Social Engineering Attempts to Include Backdoor in Distros
- https://bugs.debian.org/cgi-bin/bugreport.cgi?bug=1067708
- https://news.ycombinator.com/item?id=39866275

Github Repo (now disabled)
- https://github.com/tukaani-project/xz

Statements from Distributions
- https://www.kali.org/blog/about-the-xz-backdoor/
- https://archlinux.org/news/the-xz-package-has-been-backdoored/
- https://access.redhat.com/security/cve/CVE-2024-3094
- https://bugs.gentoo.org/928134
- https://bugs.debian.org/cgi-bin/bugreport.cgi?bug=1068024

##### misc
- https://xeiaso.net/notes/2024/xz-vuln/

- https://www.mail-archive.com/xz-devel@tukaani.org/msg00571.html
 
- https://nvd.nist.gov/vuln/detail/CVE-2024-3094

- https://linuxsecurity.com/advisories/debian/debian-dsa-5649-1-xz-utils-security-update-miwy4lbzklq4

- https://lists.debian.org/debian-security-announce/2024/msg00057.html

- https://www.redhat.com/en/blog/urgent-security-alert-fedora-41-and-rawhide-users

- https://www.phoronix.com/news/XZ-CVE-2024-3094

- https://www.openwall.com/lists/oss-security/2024/03/29/4

- https://www.virustotal.com/gui/file/13d2a7961d5b7142cc4666f1997b0738d3bc4df904814febfed5c68c29e485d4/detection

- https://www.reddit.com/r/linux/comments/1bqt999/backdoor_in_upstream_xzliblzma_leading_to_ssh/

- https://www.reddit.com/r/sysadmin/comments/1bqu3zx/backdoor_in_upstream_xzliblzma_leading_to_ssh/

- https://www.sdxcentral.com/articles/reported-supply-chain-compromise-affecting-xz-utils-data-compression-library-cve-2024-3094/2024/03/

- https://linuxsecurity.com/advisories/debian/debian-dsa-5649-1-xz-utils-security-update-miwy4lbzklq4

- https://en.wikipedia.org/wiki/XZ_Utils
