# CNEXT exploits

Exploits for CNEXT (CVE-2024-2961), a buffer overflow in the glibc's iconv(), by [@cfreal_](https://twitter.com/cfreal_)

# Usage

```bash
$ git clone --recurse-submodules https://github.com/ambionics/cnext-exploits.git
$ pip install -r requirements.txt
```

# Technical analysis

The vulnerability and exploits are described in the following blogposts:

- [Iconv, set the charset to RCE: Exploiting the glibc to hack the PHP engine (part 1)](https://www.ambionics.io/blog/iconv-cve-2024-2961-p1): PHP filters
- [Iconv, set the charset to RCE: Exploiting the glibc to hack the PHP engine (part 2)](https://www.ambionics.io/blog/iconv-cve-2024-2961-p2): direct `iconv()` calls, Roundcube
- [Iconv, set the charset to RCE: Exploiting the glibc to hack the PHP engine (part 3)](https://www.ambionics.io/blog/iconv-cve-2024-2961-p3): PHP filters, blind

# Exploits

- [CNEXT: file read to RCE exploit](cnext-exploit.py)
- [Blind CNEXT: blind file read to RCE exploit](blind-cnext-exploit.py)
- [Roundcube: authenticated RCE exploit](roundcube-exploit.py)
- [CosmicSting + CNEXT: RCE on Magento <= 2.4.7](cosmicsting-cnext-exploit.py)
