## 介绍

[分析](./analysis_zh.md)

`js2py`是一个知名的python包，它可以在python解释器中执行JS代码。其经常用在各类爬虫中，用于解析网页的JS代码。

`js2py`的某个全局变量存在一个漏洞，攻击者可以使用这个漏洞在js代码中获得一个python对象的引用，使得攻击者可以逃逸js环境，在主机上执行任意命令。

用户一般会调用`js2py.disable_pyimport()`阻止JS代码使用`pyimport`调用python模块，从而防止代码沙盒逃逸。但是使用这个漏洞，攻击者可以绕过这个限制，在主机上执行任意代码。

攻击者可以在一个钓鱼网页上包含一个恶意的js代码文件，让爬虫爬取并解析；也可以通过HTTP请求将恶意代码发送给受害者解析。攻击者可以据此在受害者机器上执行任意python代码，从而执行任意shell指令，实现RCE.

## 漏洞细节

- 影响的版本:
  - 在python3下运行的js2py(<=0.74)
- 影响的代码:
  - [pyload/pyload](https://github.com/pyload/pyload)
  - [VeNoMouS/cloudscraper](https://github.com/VeNoMouS/cloudscraper) (用js2py作为“js解析器”)
  - [dipu-bd/lightnovel-crawler](https://github.com/dipu-bd/lightnovel-crawler)
- 重现步骤:
  - 安装python3(不含3.12以上版本)，`js2py`仍不支持python3.12
  - 运行`pip install js2py`安装`js2py`并执行`poc.py`，其会在主机上执行`head -n 1 /etc/passwd; calc; gnome-calculator; kcalc;`
  - 如果漏洞存在则脚本会打印`Success! the vulnerability exists...`或者弹出计算器

## 修复

官方修复暂时不存在，可以使用`fix.py`中的代码动态patch`js2py`，也可以使用patch.txt手动修复原代码

