## Introduction

[中文](./README_zh.md)

[Analysis (Chinese)](./analysis_zh.md)

[Analysis (English)](./analysis_en.md)

`js2py` is a popular python package that can evaluate javascript code inside python interpreter. It is used by various web scrapers to parse javascript code on the website.

There exists a vulnerability in the implementation of a global variable inside `js2py`, allowing an attacker obtaining a reference to a python object in the js2py environment, thus enabling the attacker to escape JS environment and execute arbitrary commands on the host.

Normally, a user would call `js2py.disable_pyimport()` to stop JavaScript code from escaping the `js2py` environment. But with this vulnerability, an attacker can evade this restriction and execute any command on the target host.

The threat actor can host a website containing a malicious JavaScript file or send a malicious script via HTTP API for victim to parse. By doing that, the actor can commit remote code execution on the host by executing any shell command on the target.

## Details of the vulnerability

- Version number of the affected component:
  - latest js2py (<=0.74) that runs under python 3
- affected products:
  - [pyload/pyload](https://github.com/pyload/pyload)
  - [VeNoMouS/cloudscraper](https://github.com/VeNoMouS/cloudscraper) (use js2py as a optional 'js interpreter')
  - [dipu-bd/lightnovel-crawler](https://github.com/dipu-bd/lightnovel-crawler)
- The steps to reproduce:
  - install python3 under 3.12, currently `js2py` don't support python3.12.
  - Run `pip install js2py` to install `js2py` and execute `poc.py`, which would try to execute `head -n 1 /etc/passwd; calc; gnome-calculator; kcalc;` on the host.
  - If the vulnerability exists the script should print `Success! the vulnerability exists...` or pop up calculator.

## Fix

Currently, an official fix is unavailable, users can use `fix.py` to dynamically patch js2py or use patch.txt to fix the source code.

## Others

I found this vulnerability in Feburary, and submitted a PR to the official repo. But after that, the PR was forgotten and after four months have passed, I decide to release the PoC and the fix now.
