# CVE-2024-28247 Pi-hole Arbitrary File Read

## Description
This repository contains an exploit for CVE-2024-28247, a high vulnerability (CVSS 7.6) discovered in Pi-hole, a DNS sinkhole widely used to block advertisements and track domains at the network level. 

The vulnerability arises from the mishandling of file paths when accessed via the "file://" handler, allowing a remote attacker to read arbitrary files on the system. 

Exploiting this vulnerability enables the attacker to control the path of the files to read, thereby permitting the reading of arbitrary files on the system with root privileges. 

Such a security flaw not only breaches the system's data confidentiality but also undermines its integrity by allowing unauthorized access to sensitive information.

Affected Versions:
- Up to Pi-hole version 5.17.3, with the issue resolved in version 5.18.

## Installation
Ensure Python is installed on your system to utilize this exploit. Clone the repository and set up the necessary environment as follows:

```bash
git clone https://github.com/T0X1Cx/CVE-2024-28247-Pi-hole-Arbitrary-File-Read.git
cd CVE-2024-28247-Pi-hole-Arbitrary-File-Read
pip install -r requirements.txt
```

## Usage
Execute the exploit using the command below:

```bash
python3 exploit.py [Pi-Hole URL] [Admin password]
```

## Proof of Concept

![POC](https://raw.githubusercontent.com/T0X1Cx/CVE-2024-28247-Pi-hole-Arbitrary-File-Read/main/poc.png)

## Disclaimer
This exploit is for educational and ethical security testing purposes only. The use of this exploit against targets without prior mutual consent is illegal, and the developer disclaims any liability for misuse or damage caused by this exploit.

## Credits
Exploit developed by Julio Ángel Ferrari (Aka. T0X1Cx)
