# Wall-Escape (CVE-2024-28085)

The util-linux wall command does not filter escape sequences from 
command line arguments. The vulnerable code was introduced in commit
[cdd3cc7fa4](https://github.com/util-linux/util-linux/commit/cdd3cc7fa4cafde492039180bb47f27ab8422261) (2013). Every version since has been vulnerable. A full report
can be found [here](https://people.rit.edu/sjf5462/6831711781/wall_2_27_2024.txt). I
have nicknamed this bug "WallEscape".

This exploit code was successful in leaking passwords on Ubuntu 22.04 with default configurations. 

## Configure

Make sure the background color and username are set to appropriate values in
throw.c.

## Build and run

Attack setup
```
git clone https://github.com/skyler-ferrante/CVE-2024-28085.git
./build.sh
./spy > proc.log & ./watch "sudo systemctl start apache2"; ./watch "systemctl start apache2"; sleep .01; ./throw
```

I used `sudo systemctl start apache2` since it is short running without much output.
Make sure to kill spy after the exploit has run: `pkill spy`.

Then in another terminal
```
sudo su
sudo systemctl start apache2
```

It might not be necessary for the victim to call `su` depending on the system, and if accessing locally vs through ssh.

This should cause the fake sudo prompt to pop up in the victim terminal. Since
many systems leak commands that are not found, the victim password may show up in proc.log.

Example proc.log
```
sudo systemctl start apache2
systemctl start apache2
./throw
bash
/usr/bin/python3 /usr/lib/command-not-found -- Password123!
/usr/bin/snap advise-snap --format=json --command Password123!
```

# Note

Some people have misunderstood under what scenarios this could be used to attack another user. We do not need to attack sudo, we can attack anywhere the user inputs their password. On my system, after a user logs in using OpenSSH, the command `/usr/bin/env -i PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin run-parts --lsbsysinit /etc/update-motd.d > /run/motd.dynamic.new` gets run.

For leaking passwords from Openssh users, imagine running the following:

```
./watch "sh -c /usr/bin/env -i PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin run-parts --lsbsysinit /etc/update-motd.d > /run/motd.dynamic.new"; sleep 1; ./throw
```

We can then send a "password incorrect" message after a user can correctly login through SSH. Sudo was just the command I choose to demo, but there are many possible targets. Its not hard to imagine an attacker setting up a credential harvester, to harvest the credentials of every user that logins using SSH. This is possible from even the most unprivileged users, such as www-data.

This vulnerability also gives attackers the ability to change the output of any command. Imagine we waited for the command `cat ~/.ssh/id_rsa.pub"`. An attacker could change what the user copies for their public key. In the style of attack, we do not need a leaking primitive for commands not found.
