# CVE-2024-27304-PoC

## references
- [DEF CON 32 - SQL Injection Isn't Dead Smuggling Queries at the Protocol Level - Paul Gerste](https://www.youtube.com/watch?v=Tfg1B8u1yvE)
- [pgx SQL Injection via Protocol Message Size Overflow](https://github.com/advisories/GHSA-mrww-27vc-gghv)

## webapp
A simple web application with login functionality. Only administrators can log in.

This application uses PostgreSQL and pgx v5.5.3 (vulnerable version).

The attacker attempts to log in by maliciously inserting records into the users table. However, since placeholders are used, traditional SQL injection does not work.

## exploit
PostgreSQL Message Formats: https://www.postgresql.org/docs/17/protocol-message-formats.html

The exploit depends on the message format that pgx sends to the database server when executing SQL.
By default, pgx sends a prepared statement with `P(Parse)` and then sends parameters with `B(Bind)`.

If the following configuration is set, pgx sends the interpolated query with `Q(Query)`:
```go
cfg.ConnConfig.DefaultQueryExecMode = pgx.QueryExecModeSimpleProtocol
```

You can view the actual messages using tcpdump with the `-X` option.

### scripts

- `Q_simple.py`: Causes overflow with `Q(Query)`. Assumes the attacker has complete knowledge of the query being executed (if black-box, bruteforce is required).
- `Q_nop_sled.py`: Causes overflow with `Q(Query)`. Succeeds in exploitation within 5 attempts.
- `B_simple.py`: Causes overflow with `B(Bind)`. Assumes the attacker has complete knowledge of the query being executed (in my opinion, `B(Bind)` exploitation is difficult in black-box scenarios).

### Notes
- A large amount of memory is required to successfully execute the exploit.
- This exploit sends an extremely large payload and may cause a DoS. As mentioned in the video, **do not execute this exploit against third-party systems**.
