#!/bin/bash
# Made with ✨ Magic ©️ Nur Mukhammad Agus (https://github.com/madfxr), 2024. Free and Open Source Software (FOSS).
RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[0;33m'
WHITE='\033[0;97m'
NC='\033[0m'

kernel_version=""
affected_status=""
cvss_score="${RED}7.8 High${NC}"
cve_id="${RED}https://nvd.nist.gov/vuln/detail/CVE-2024-26581${NC}"

echo -e "${YELLOW}
 ██████╗██╗   ██╗███████╗    ██████╗  ██████╗ ██████╗ ██╗  ██╗      ██████╗  ██████╗ ███████╗ █████╗  ██╗
██╔════╝██║   ██║██╔════╝    ╚════██╗██╔═████╗╚════██╗██║  ██║      ╚════██╗██╔════╝ ██╔════╝██╔══██╗███║
██║     ██║   ██║█████╗█████╗ █████╔╝██║██╔██║ █████╔╝███████║█████╗ █████╔╝███████╗ ███████╗╚█████╔╝╚██║
██║     ╚██╗ ██╔╝██╔══╝╚════╝██╔═══╝ ████╔╝██║██╔═══╝ ╚════██║╚════╝██╔═══╝ ██╔═══██╗╚════██║██╔══██╗ ██║
╚██████╗ ╚████╔╝ ███████╗    ███████╗╚██████╔╝███████╗     ██║      ███████╗╚██████╔╝███████║╚█████╔╝ ██║
 ╚═════╝  ╚═══╝  ╚══════╝    ╚══════╝ ╚═════╝ ╚══════╝     ╚═╝      ╚══════╝ ╚═════╝ ╚══════╝ ╚════╝  ╚═╝
                           ✦✦✦ VULNERABILITY CHECKER FOR BGN INTERNAL ✦✦✦

${NC}"

is_vulnerable() {
    local major=$1
    local minor=$2
    local patch=$3

    kernel_major=$(echo "$kernel_version" | cut -d'.' -f1)
    kernel_minor=$(echo "$kernel_version" | cut -d'.' -f2)
    kernel_patch=$(echo "$kernel_version" | cut -d'.' -f3)

    if [[ "$kernel_major" =~ ^[0-9]+$ ]] && [[ "$kernel_minor" =~ ^[0-9]+$ ]] && [[ "$kernel_patch" =~ ^[0-9]+$ ]]; then
        if [ "$kernel_major" -gt "$major" ]; then
            return 0
        elif [ "$kernel_major" -eq "$major" ]; then
            if [ "$kernel_minor" -gt "$minor" ]; then
                return 0
            elif [ "$kernel_minor" -eq "$minor" ]; then
                if [ "$kernel_patch" -ge "$patch" ]; then
                    return 0
                fi
            fi
        fi
    fi
    return 1
}

get_kernel_version() {
     echo -e "${WHITE}[INPUT] Enter the Kernel Version to Check (Example: 6.6.6): ${NC}\c"
     read -p "" input_kernel_version

     extracted_version=$(echo "$input_kernel_version" | grep -oP '^\d+\.\d+\.\d+')

    if [[ $extracted_version =~ ^[0-9]+\.[0-9]+\.[0-9]+$ ]]; then
        kernel_version="$extracted_version"
        kernel_detected=true
        echo -e "${YELLOW}[DEBUG] Display the Current Kernel Version...${NC}"
        echo -e "${GREEN}[DEBUG] Output: $input_kernel_version${NC}"
    else
        echo -e "${RED}[ERROR] Kernel Version Not Detected${NC}"
        exit 1
    fi
}

check_vulnerability() {
    echo -e "${YELLOW}[DEBUG] Checking for Vulnerabilities Based on Kernel Version...${NC}"

    if (is_vulnerable 5 5 0 && ! is_vulnerable 5 10 210) || \
       (is_vulnerable 5 11 0 && ! is_vulnerable 5 15 149) || \
       (is_vulnerable 5 16 0 && ! is_vulnerable 6 1 78) || \
       (is_vulnerable 6 2 0 && ! is_vulnerable 6 6 17) || \
       (is_vulnerable 6 7 0 && ! is_vulnerable 6 7 5); then
        affected_status="${RED}Affected${NC}"
    elif (is_vulnerable 2 6 27 && ! is_vulnerable 5 4 269) || \
         (is_vulnerable 5 10 210) || \
         (is_vulnerable 5 15 149) || \
         (is_vulnerable 6 1 78) || \
         (is_vulnerable 6 6 17) || \
         (is_vulnerable 6 7 5 && ! is_vulnerable 6 12 0); then
        affected_status="${GREEN}Not Affected${NC}"
    else
        affected_status="${GREEN}Not Affected${NC}"
    fi
}

get_kernel_version
echo -e "${GREEN}[DEBUG] Started Checking for CVE-2024-26581...${NC}"
check_vulnerability
echo -e "${GREEN}[DEBUG] Checking Completed!${NC}"

echo -e "${GREEN}[SUMMARY] Display of Checking Results:${NC}"
echo -e "‣ ${WHITE}Kernel Version:${NC} ${GREEN}$input_kernel_version${NC}"

if [ "$affected_status" = "${RED}Affected${NC}" ]; then
    echo -e "‣ ${WHITE}Vulnerability Status:${NC} ${affected_status}"
    echo -e "‣ ${WHITE}CVE ID:${NC} ${cve_id}"
    echo -e "‣ ${WHITE}CVSS Score:${NC} ${cvss_score}"
else
    echo -e "‣ ${WHITE}Vulnerability Status:${NC} ${affected_status}"
fi
